/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.crafting;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.inventory.AltarRecipeInventory;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class AltarRecipe
implements Recipe<AltarRecipeInventory> {
    private final ResourceLocation id;
    private final EntityType<?> entityType;
    @Nullable
    private final CompoundTag extraData;
    private final float powerCost;
    private final NonNullList<Ingredient> inputs;
    private final boolean isItemCraft;
    private final ItemStack resultItem;
    private final Ingredient copyInput;
    @Nullable
    private final String copyTag;

    public AltarRecipe(ResourceLocation id, EntityType<?> entityType, @Nullable CompoundTag extraData, float powerCost, Ingredient copyInput, @Nullable String copyTag, Ingredient ... inputs) {
        Preconditions.checkArgument((0 < inputs.length && inputs.length <= 6 ? 1 : 0) != 0, (Object)"Ingredients count is illegal!");
        this.id = id;
        this.entityType = entityType;
        this.isItemCraft = entityType == EntityType.f_20461_;
        this.resultItem = this.isItemCraft && extraData != null ? ItemStack.m_41712_((CompoundTag)extraData.m_128469_("Item")) : ItemStack.f_41583_;
        this.copyInput = copyInput;
        this.copyTag = copyTag;
        this.extraData = extraData;
        this.powerCost = powerCost;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])this.fillInputs(inputs));
    }

    public AltarRecipe(ResourceLocation id, EntityType<?> entityType, @Nullable CompoundTag extraData, float powerCost, Ingredient ... inputs) {
        this(id, entityType, extraData, powerCost, Ingredient.f_43901_, (String)null, inputs);
    }

    public boolean matches(AltarRecipeInventory inv, Level worldIn) {
        return RecipeMatcher.findMatches(inv.getItems(), this.inputs) != null;
    }

    public ItemStack assemble(AltarRecipeInventory inv, RegistryAccess access) {
        return this.m_8043_(access).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.resultItem;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)InitRecipes.ALTAR_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return InitRecipes.ALTAR_CRAFTING;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8042_() {
        return ((Item)InitItems.HAKUREI_GOHEI.get()).m_7968_();
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    @Nullable
    public CompoundTag getExtraData() {
        return this.extraData;
    }

    public float getPowerCost() {
        return this.powerCost;
    }

    public Ingredient getCopyInput() {
        return this.copyInput;
    }

    @Nullable
    public String getCopyTag() {
        return this.copyTag;
    }

    public void spawnOutputEntity(ServerLevel world, BlockPos pos, @Nullable AltarRecipeInventory inventory) {
        if (this.extraData != null) {
            CompoundTag nbt = this.extraData.m_6426_();
            nbt.m_128359_("id", Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(this.entityType)).toString());
            Entity resultEntity = EntityType.m_20645_((CompoundTag)nbt, (Level)world, e -> {
                e.m_7678_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), e.m_146908_(), e.m_146909_());
                this.finalizeSpawn(world, pos, (Entity)e);
                return e;
            });
            if (resultEntity != null) {
                this.finalizeSpawn(world, pos, resultEntity);
                this.copyIngredientTag(inventory, resultEntity);
                world.m_8860_(resultEntity);
            }
            return;
        }
        this.entityType.m_20592_(world, null, (Player)null, pos, MobSpawnType.SPAWN_EGG, true, true);
    }

    private void copyIngredientTag(@Nullable AltarRecipeInventory inventory, Entity resultEntity) {
        CompoundTag data;
        ItemStack matchStack;
        if (inventory != null && this.copyInput != Ingredient.f_43901_ && !(matchStack = inventory.getMatchIngredient(this.copyInput)).m_41619_() && (data = StringUtils.isEmpty((CharSequence)this.copyTag) ? matchStack.m_41783_() : matchStack.m_41737_(this.copyTag)) != null && !data.m_128456_()) {
            if (resultEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)resultEntity;
                livingEntity.m_7378_(data);
            }
            if (resultEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)resultEntity;
                itemEntity.m_7378_(data);
            }
        }
    }

    public boolean isItemCraft() {
        return this.isItemCraft;
    }

    private void finalizeSpawn(ServerLevel world, BlockPos pos, @Nullable Entity entity) {
        if (entity instanceof Mob) {
            ((Mob)entity).m_6518_((ServerLevelAccessor)world, world.m_6436_(pos), MobSpawnType.SPAWN_EGG, null, null);
        }
    }

    private Ingredient[] fillInputs(Ingredient[] inputs) {
        Ingredient[] newInputs = new Ingredient[6];
        for (int i = 0; i < 6; ++i) {
            newInputs[i] = i < inputs.length ? inputs[i] : Ingredient.f_43901_;
        }
        return newInputs;
    }
}

