/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.tacz.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai.GunAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.ai.GunWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.compat.tacz.utils.GunBehaviorUtils;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.item.ItemStack;

public class TaskGunAttack
implements IAttackTask {
    public static final ResourceLocation UID = new ResourceLocation("touhou_little_maid", "gun_attack");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return GunItemBuilder.create().setId(new ResourceLocation("tacz", "glock_17")).build();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get(), 0.5f);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.m_257741_(this::mainhandHoldGun, GunBehaviorUtils::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.m_257990_(target -> !this.mainhandHoldGun(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl<EntityMaid> gunWalkTargetTask = GunWalkToTarget.create(0.6f);
        GunAttackStrafingTask gunAttackStrafingTask = new GunAttackStrafingTask();
        GunShootTargetTask gunShootTargetTask = new GunShootTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, gunWalkTargetTask), Pair.of((Object)5, (Object)((Object)gunAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)gunShootTargetTask))});
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_tacz_gun", this::mainhandHoldGun));
    }

    private boolean mainhandHoldGun(EntityMaid maid) {
        return IGun.mainhandHoldGun((LivingEntity)maid);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.m_20270_((Entity)target) > (float)((Integer)MaidConfig.MAID_GUN_LONG_DISTANCE.get()).intValue();
    }
}

