/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class EntityPowerPointRenderer
extends EntityRenderer<EntityPowerPoint> {
    private static final ResourceLocation POWER_POINT_TEXTURES = new ResourceLocation("touhou_little_maid", "textures/entity/power_point.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110467_((ResourceLocation)POWER_POINT_TEXTURES);

    public EntityPowerPointRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    private static void vertex(VertexConsumer bufferIn, Matrix4f pose, Matrix3f normal, double x, double y, double texU, double texV, int packedLight) {
        bufferIn.m_252986_(pose, (float)x, (float)y, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)texU, (float)texV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public void render(EntityPowerPoint entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        int texIndex = entity.getIcon();
        int remainder = texIndex % 4;
        int quotient = texIndex / 4;
        double texPos1 = (double)(remainder * 16) / 64.0;
        double texPos2 = (double)(remainder * 16 + 16) / 64.0;
        double texPos3 = (double)(quotient * 16) / 64.0;
        double texPos4 = (double)(quotient * 16 + 16) / 64.0;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.1, 0.0);
        poseStack.m_252781_(this.f_114476_.m_253208_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        poseStack.m_85841_(0.3f, 0.3f, 0.3f);
        VertexConsumer buffer = bufferIn.m_6299_(RENDER_TYPE);
        PoseStack.Pose poseStackLast = poseStack.m_85850_();
        Matrix4f pose = poseStackLast.m_252922_();
        Matrix3f normal = poseStackLast.m_252943_();
        EntityPowerPointRenderer.vertex(buffer, pose, normal, -1.0, -0.25, texPos1, texPos4, packedLightIn);
        EntityPowerPointRenderer.vertex(buffer, pose, normal, 1.0, -0.25, texPos2, texPos4, packedLightIn);
        EntityPowerPointRenderer.vertex(buffer, pose, normal, 1.0, 1.75, texPos2, texPos3, packedLightIn);
        EntityPowerPointRenderer.vertex(buffer, pose, normal, -1.0, 1.75, texPos1, texPos3, packedLightIn);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntityPowerPoint entity) {
        return POWER_POINT_TEXTURES;
    }
}

