/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.api.entity.IMaid;
import com.github.tartaricacid.touhoulittlemaid.api.event.client.RenderMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.ChatBubbleRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.GeckoEntityMaidRenderer;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackItem;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBanner;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidBipedHead;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.entity.layer.LayerMaidHeldItem;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import com.github.tartaricacid.touhoulittlemaid.client.resource.models.MaidModels;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.InGameMaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class EntityMaidRenderer
extends MobRenderer<Mob, BedrockModel<Mob>> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("touhou_little_maid", "textures/entity/empty.png");
    private static final String DEFAULT_MODEL_ID = "touhou_little_maid:hakurei_reimu";
    private final GeckoEntityMaidRenderer geckoEntityMaidRenderer;
    private MaidModelInfo mainInfo;
    private List<Object> mainAnimations = Lists.newArrayList();

    public EntityMaidRenderer(EntityRendererProvider.Context manager) {
        super(manager, new BedrockModel(), 0.5f);
        this.m_115326_(new LayerMaidHeldItem(this, manager.m_234598_()));
        this.m_115326_(new LayerMaidBipedHead(this, manager.m_174027_()));
        this.m_115326_(new LayerMaidBackpack(this, manager.m_174027_()));
        this.m_115326_(new LayerMaidBackItem(this));
        this.m_115326_(new LayerMaidBanner(this, manager.m_174027_()));
        this.geckoEntityMaidRenderer = new GeckoEntityMaidRenderer(manager);
    }

    public void m_7392_(Mob entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        IMaid maid = IMaid.convert(entity);
        if (maid == null) {
            return;
        }
        CustomPackLoader.MAID_MODELS.getModel(DEFAULT_MODEL_ID).ifPresent(model -> {
            this.f_115290_ = model;
        });
        CustomPackLoader.MAID_MODELS.getInfo(DEFAULT_MODEL_ID).ifPresent(info -> {
            this.mainInfo = info;
        });
        CustomPackLoader.MAID_MODELS.getAnimation(DEFAULT_MODEL_ID).ifPresent(animations -> {
            this.mainAnimations = animations;
        });
        MaidModels.ModelData eventModelData = new MaidModels.ModelData((BedrockModel)this.f_115290_, this.mainInfo, this.mainAnimations);
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderMaidEvent(maid, eventModelData))) {
            BedrockModel<Mob> bedrockModel = eventModelData.getModel();
            if (bedrockModel != null) {
                this.f_115290_ = bedrockModel;
            }
            this.mainInfo = eventModelData.getInfo();
            this.mainAnimations = eventModelData.getAnimations();
        } else {
            CustomPackLoader.MAID_MODELS.getModel(maid.getModelId()).ifPresent(model -> {
                this.f_115290_ = model;
            });
            CustomPackLoader.MAID_MODELS.getInfo(maid.getModelId()).ifPresent(info -> {
                this.mainInfo = info;
            });
            CustomPackLoader.MAID_MODELS.getAnimation(maid.getModelId()).ifPresent(animations -> {
                this.mainAnimations = animations;
            });
        }
        EntityMaid maidEntity = maid.asStrictMaid();
        if (maidEntity != null && InGameMaidConfig.INSTANCE.isShowChatBubble()) {
            ChatBubbleRenderer.renderChatBubble(this, maidEntity, poseStack, bufferIn, packedLightIn);
        }
        if (this.mainInfo.isGeckoModel()) {
            this.geckoEntityMaidRenderer.getAnimatableEntity(entity).setMaidInfo(this.mainInfo);
            this.geckoEntityMaidRenderer.render(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
            return;
        }
        ((BedrockModel)this.f_115290_).setAnimations(this.mainAnimations);
        GlWrapper.setPoseStack(poseStack);
        super.m_7392_(entity, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
        GlWrapper.clearPoseStack();
    }

    protected void scale(Mob maid, PoseStack poseStack, float partialTickTime) {
        float scale = this.mainInfo.getRenderEntityScale();
        poseStack.m_85841_(scale, scale, scale);
    }

    protected void setupRotations(Mob mob, PoseStack poseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_((LivingEntity)mob, poseStack, pAgeInTicks, pRotationYaw, pPartialTicks);
        if (mob.m_20202_() instanceof Player && !this.mainInfo.isGeckoModel()) {
            poseStack.m_85837_(-0.375, 0.8325, 0.375);
            poseStack.m_252781_(Axis.f_252393_.m_252977_(65.0f));
            poseStack.m_252781_(Axis.f_252392_.m_252977_(-80.0f));
        }
    }

    public ResourceLocation getTextureLocation(Mob maid) {
        if (this.mainInfo == null) {
            return DEFAULT_TEXTURE;
        }
        return this.mainInfo.getTexture();
    }

    public MaidModelInfo getMainInfo() {
        return this.mainInfo;
    }

    public EntityRenderDispatcher getDispatcher() {
        return this.f_114476_;
    }
}

