/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.pojo.BedrockModelPOJO;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;

public enum BedrockVersion {
    LEGACY("[1.10.0]"),
    NEW("[1.12.0,)");

    private final VersionRange versionRange;

    private BedrockVersion(String version) {
        this.versionRange = BedrockVersion.createFromVersionSpec(version);
    }

    public static boolean isNewVersion(BedrockModelPOJO bedrockModel) {
        DefaultArtifactVersion inputVersion = new DefaultArtifactVersion(bedrockModel.getFormatVersion());
        return BedrockVersion.NEW.versionRange.containsVersion((ArtifactVersion)inputVersion);
    }

    public static boolean isLegacyVersion(BedrockModelPOJO bedrockModel) {
        DefaultArtifactVersion inputVersion = new DefaultArtifactVersion(bedrockModel.getFormatVersion());
        return BedrockVersion.LEGACY.versionRange.containsVersion((ArtifactVersion)inputVersion);
    }

    private static VersionRange createFromVersionSpec(String spec) {
        try {
            return VersionRange.createFromVersionSpec((String)spec);
        }
        catch (InvalidVersionSpecificationException e) {
            TouhouLittleMaid.LOGGER.fatal("Failed to parse version spec {}", (Object)spec, (Object)e);
            throw new RuntimeException("Failed to parse spec", e);
        }
    }
}

