/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.inventory;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageCraft;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgeMenuType;

public class GunSmithTableMenu
extends AbstractContainerMenu {
    public static final MenuType<GunSmithTableMenu> TYPE = IForgeMenuType.create((windowId, inv, data) -> new GunSmithTableMenu(windowId, inv));

    public GunSmithTableMenu(int id, Inventory inventory) {
        super(TYPE, id);
    }

    public ItemStack m_7648_(Player player, int pIndex) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_6084_();
    }

    public void doCraft(ResourceLocation recipeId, Player player) {
        TimelessAPI.getRecipe(recipeId).ifPresent(recipe -> player.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> {
            Int2IntArrayMap recordCount = new Int2IntArrayMap();
            List<GunSmithTableIngredient> ingredients = recipe.getInputs();
            for (GunSmithTableIngredient ingredient : ingredients) {
                int count = 0;
                for (int slotIndex = 0; slotIndex < handler.getSlots(); ++slotIndex) {
                    ItemStack stack = handler.getStackInSlot(slotIndex);
                    int stackCount = stack.m_41613_();
                    if (stack.m_41619_() || !ingredient.getIngredient().test(stack)) continue;
                    if ((count += stackCount) <= ingredient.getCount()) {
                        recordCount.put(slotIndex, stackCount);
                        continue;
                    }
                    int remaining = count - ingredient.getCount();
                    recordCount.put(slotIndex, stackCount - remaining);
                    break;
                }
                if (count >= ingredient.getCount()) continue;
                return;
            }
            IntIterator intIterator = recordCount.keySet().iterator();
            while (intIterator.hasNext()) {
                int slotIndex = (Integer)intIterator.next();
                handler.extractItem(slotIndex, recordCount.get(slotIndex), false);
            }
            Level level = player.m_9236_();
            if (!level.f_46443_) {
                ItemEntity itemEntity = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), recipe.m_8043_(player.m_9236_().m_9598_()).m_41777_());
                itemEntity.m_32010_(0);
                level.m_7967_((Entity)itemEntity);
            }
            player.f_36095_.m_182423_();
            NetworkHandler.sendToClientPlayer(new ServerMessageCraft(this.f_38840_), player);
        }));
    }
}

