/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.event.common.GunMeleeEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerMelee;
import com.tacz.guns.resource.pojo.data.attachment.MeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunDefaultMeleeData;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LocalPlayerMelee {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;
    private int meleeCounter = 0;

    public LocalPlayerMelee(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void melee() {
        if (this.data.clientStateLock) {
            return;
        }
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        ResourceLocation muzzleId = iGun.getAttachmentId(mainhandItem, AttachmentType.MUZZLE);
        MeleeData muzzleMeleeData = this.getMeleeData(muzzleId);
        if (muzzleMeleeData != null) {
            this.doMuzzleMelee(gunId);
            return;
        }
        ResourceLocation stockId = iGun.getAttachmentId(mainhandItem, AttachmentType.STOCK);
        MeleeData stockMeleeData = this.getMeleeData(stockId);
        if (stockMeleeData != null) {
            this.doStockMelee(gunId);
            return;
        }
        TimelessAPI.getClientGunIndex(gunId).ifPresent(index -> {
            GunDefaultMeleeData defaultMeleeData = index.getGunData().getMeleeData().getDefaultMeleeData();
            if (defaultMeleeData == null) {
                return;
            }
            String animationType = defaultMeleeData.getAnimationType();
            if ("melee_stock".equals(animationType)) {
                this.doStockMelee(gunId);
                return;
            }
            this.doPushMelee(gunId);
        });
    }

    private boolean prepareMelee() {
        this.data.lockState(operator -> operator.getSynMeleeCoolDown() > 0L);
        GunMeleeEvent gunMeleeEvent = new GunMeleeEvent((LivingEntity)this.player, this.player.m_21205_(), LogicalSide.CLIENT);
        return !MinecraftForge.EVENT_BUS.post((Event)gunMeleeEvent);
    }

    private void doMuzzleMelee(ResourceLocation gunId) {
        if (this.prepareMelee()) {
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                SoundPlayManager.playMeleeBayonetSound((LivingEntity)this.player, gunIndex);
                NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerMelee());
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onBayonetAttack(this.meleeCounter);
                    this.meleeCounter = (this.meleeCounter + 1) % 3;
                }
            });
        }
    }

    private void doStockMelee(ResourceLocation gunId) {
        if (this.prepareMelee()) {
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                SoundPlayManager.playMeleeStockSound((LivingEntity)this.player, gunIndex);
                NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerMelee());
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onStockAttack();
                }
            });
        }
    }

    private void doPushMelee(ResourceLocation gunId) {
        if (this.prepareMelee()) {
            TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
                SoundPlayManager.playMeleePushSound((LivingEntity)this.player, gunIndex);
                NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerMelee());
                GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
                if (animationStateMachine != null) {
                    animationStateMachine.onPushAttack();
                }
            });
        }
    }

    @Nullable
    private MeleeData getMeleeData(ResourceLocation attachmentId) {
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            return null;
        }
        return TimelessAPI.getClientAttachmentIndex(attachmentId).map(index -> index.getData().getMeleeData()).orElse(null);
    }
}

