/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation.statemachine;

import com.tacz.guns.api.client.animation.statemachine.AnimationState;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateContext;
import com.tacz.guns.api.client.animation.statemachine.LuaContextWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;

public class LuaAnimationState<T extends AnimationStateContext>
implements AnimationState<LuaContextWrapper<T>> {
    @Nonnull
    private final LuaTable luaTable;
    @Nullable
    private final LuaFunction updateFunction;
    @Nullable
    private final LuaFunction enterFunction;
    @Nullable
    private final LuaFunction exitFunction;
    @Nullable
    private final LuaFunction transitionFunction;

    LuaAnimationState(@Nonnull LuaTable luaTable) {
        this.luaTable = luaTable;
        this.updateFunction = this.checkLuaFunction("update");
        this.enterFunction = this.checkLuaFunction("entry");
        this.exitFunction = this.checkLuaFunction("exit");
        this.transitionFunction = this.checkLuaFunction("transition");
    }

    @Override
    public void update(LuaContextWrapper<T> context) {
        if (this.updateFunction != null) {
            this.updateFunction.call(context.getLuaContext());
        }
    }

    @Override
    public void entryAction(LuaContextWrapper<T> context) {
        if (this.enterFunction != null) {
            this.enterFunction.call(context.getLuaContext());
        }
    }

    @Override
    public void exitAction(LuaContextWrapper<T> context) {
        if (this.exitFunction != null) {
            this.exitFunction.call(context.getLuaContext());
        }
    }

    @Override
    public AnimationState<LuaContextWrapper<T>> transition(LuaContextWrapper<T> context, String condition) {
        if (this.transitionFunction != null) {
            LuaString conditionToLua = LuaString.valueOf((String)condition);
            LuaValue nextStateTable = this.transitionFunction.call(context.getLuaContext(), (LuaValue)conditionToLua);
            if (nextStateTable.istable()) {
                return new LuaAnimationState<T>((LuaTable)nextStateTable);
            }
            if (nextStateTable.isnil()) {
                return null;
            }
            throw new LuaError("the return of function 'transition' must be table or nil");
        }
        return null;
    }

    private LuaFunction checkLuaFunction(String funcName) {
        LuaValue value = this.luaTable.get(funcName);
        if (value.isfunction()) {
            return (LuaFunction)value;
        }
        if (value.isnil()) {
            return null;
        }
        throw new LuaError("the type of field '" + funcName + "' must be function or nil");
    }
}

