/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.dh;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogDrawMode;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRenderPass;
import com.seibel.distanthorizons.api.interfaces.override.IDhApiOverrideable;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiFramebuffer;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShadowCullingFrustum;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterDhInitEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeApplyShaderRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeBufferRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDeferredRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderCleanupEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderPassEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderSetupEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeTextureClearEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiColorDepthTextureCreatedEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiCancelableEventParam;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiEventParam;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.coreapi.DependencyInjection.OverrideInjector;
import com.seibel.distanthorizons.coreapi.interfaces.dependencyInjection.IBindable;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.compat.dh.DHCompat;
import net.irisshaders.iris.compat.dh.DHCompatInternal;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shadows.ShadowRenderer;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GL46C;

public class LodRendererEvents {
    private static boolean eventHandlersBound = false;
    private static boolean atTranslucent = false;
    private static int textureWidth;
    private static int textureHeight;

    public static void setupEventHandlers() {
        if (!eventHandlersBound) {
            eventHandlersBound = true;
            Iris.logger.info("Queuing DH event binding...");
            DhApiAfterDhInitEvent beforeCleanupEvent = new DhApiAfterDhInitEvent(){

                public void afterDistantHorizonsInit(DhApiEventParam<Void> event) {
                    Iris.logger.info("DH Ready, binding Iris event handlers...");
                    LodRendererEvents.setupSetDeferredBeforeRenderingEvent();
                    LodRendererEvents.setupReconnectDepthTextureEvent();
                    LodRendererEvents.setupCreateDepthTextureEvent();
                    LodRendererEvents.setupTransparentRendererEventCancling();
                    LodRendererEvents.setupBeforeBufferClearEvent();
                    LodRendererEvents.setupBeforeRenderCleanupEvent();
                    LodRendererEvents.beforeBufferRenderEvent();
                    LodRendererEvents.setupBeforeRenderFrameBufferBinding();
                    LodRendererEvents.setupBeforeRenderPassEvent();
                    LodRendererEvents.setupBeforeApplyShaderEvent();
                    DHCompatInternal.dhEnabled = (Boolean)DhApi.Delayed.configs.graphics().renderingEnabled().getValue();
                    Iris.logger.info("DH Iris events bound.");
                }
            };
            DhApi.events.bind(DhApiAfterDhInitEvent.class, (IBindable)beforeCleanupEvent);
        }
    }

    private static void setupSetDeferredBeforeRenderingEvent() {
        DhApiBeforeRenderEvent beforeRenderEvent = new DhApiBeforeRenderEvent(){

            public void beforeRender(DhApiCancelableEventParam<DhApiRenderParam> event) {
                DhApi.Delayed.renderProxy.setDeferTransparentRendering(IrisApi.getInstance().isShaderPackInUse() && LodRendererEvents.getInstance().shouldOverride);
                DhApi.Delayed.configs.graphics().fog().drawMode().setValue((Object)(LodRendererEvents.getInstance().shouldOverride ? EDhApiFogDrawMode.FOG_DISABLED : EDhApiFogDrawMode.FOG_ENABLED));
            }
        };
        DhApi.events.bind(DhApiBeforeRenderEvent.class, (IBindable)beforeRenderEvent);
    }

    private static void setupReconnectDepthTextureEvent() {
        DhApiBeforeTextureClearEvent beforeRenderEvent = new DhApiBeforeTextureClearEvent(){

            public void beforeClear(DhApiCancelableEventParam<DhApiRenderParam> event) {
                DhApiResult getResult = DhApi.Delayed.renderProxy.getDhDepthTextureId();
                if (getResult.success) {
                    int depthTextureId = (Integer)getResult.payload;
                    LodRendererEvents.getInstance().reconnectDHTextures(depthTextureId);
                }
            }
        };
        DhApi.events.bind(DhApiBeforeTextureClearEvent.class, (IBindable)beforeRenderEvent);
    }

    private static DHCompatInternal getInstance() {
        return (DHCompatInternal)Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::getDHCompat).map(DHCompat::getInstance).orElse(DHCompatInternal.SHADERLESS);
    }

    private static void setupCreateDepthTextureEvent() {
        DhApiColorDepthTextureCreatedEvent beforeRenderEvent = new DhApiColorDepthTextureCreatedEvent(){

            public void onResize(DhApiEventParam<DhApiColorDepthTextureCreatedEvent.EventParam> input) {
                textureWidth = ((DhApiColorDepthTextureCreatedEvent.EventParam)input.value).newWidth;
                textureHeight = ((DhApiColorDepthTextureCreatedEvent.EventParam)input.value).newHeight;
            }
        };
        DhApi.events.bind(DhApiColorDepthTextureCreatedEvent.class, (IBindable)beforeRenderEvent);
    }

    private static void setupTransparentRendererEventCancling() {
        DhApiBeforeRenderEvent beforeRenderEvent = new DhApiBeforeRenderEvent(){

            public void beforeRender(DhApiCancelableEventParam<DhApiRenderParam> event) {
                if (ShadowRenderingState.areShadowsCurrentlyBeingRendered() && !LodRendererEvents.getInstance().shouldOverrideShadow) {
                    event.cancelEvent();
                }
            }
        };
        DhApiBeforeDeferredRenderEvent beforeRenderEvent2 = new DhApiBeforeDeferredRenderEvent(){

            public void beforeRender(DhApiCancelableEventParam<DhApiRenderParam> event) {
                if (ShadowRenderingState.areShadowsCurrentlyBeingRendered() && !LodRendererEvents.getInstance().shouldOverrideShadow) {
                    event.cancelEvent();
                }
            }
        };
        DhApi.events.bind(DhApiBeforeRenderEvent.class, (IBindable)beforeRenderEvent);
        DhApi.events.bind(DhApiBeforeDeferredRenderEvent.class, (IBindable)beforeRenderEvent2);
    }

    private static void setupBeforeRenderCleanupEvent() {
        DhApiBeforeRenderCleanupEvent beforeCleanupEvent = new DhApiBeforeRenderCleanupEvent(){

            public void beforeCleanup(DhApiEventParam<DhApiRenderParam> event) {
                if (LodRendererEvents.getInstance().shouldOverride) {
                    if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                        LodRendererEvents.getInstance().getShadowShader().unbind();
                    } else {
                        LodRendererEvents.getInstance().getSolidShader().unbind();
                    }
                }
            }
        };
        DhApi.events.bind(DhApiBeforeRenderCleanupEvent.class, (IBindable)beforeCleanupEvent);
    }

    private static void setupBeforeBufferClearEvent() {
        DhApiBeforeTextureClearEvent beforeCleanupEvent = new DhApiBeforeTextureClearEvent(){

            public void beforeClear(DhApiCancelableEventParam<DhApiRenderParam> event) {
                if (((DhApiRenderParam)event.value).renderPass == EDhApiRenderPass.OPAQUE) {
                    if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                        event.cancelEvent();
                    } else if (LodRendererEvents.getInstance().shouldOverride) {
                        GL43C.glClear((int)256);
                        event.cancelEvent();
                    }
                }
            }
        };
        DhApi.events.bind(DhApiBeforeTextureClearEvent.class, (IBindable)beforeCleanupEvent);
    }

    private static void beforeBufferRenderEvent() {
        DhApiBeforeBufferRenderEvent beforeCleanupEvent = new DhApiBeforeBufferRenderEvent(){

            public void beforeRender(DhApiEventParam<DhApiBeforeBufferRenderEvent.EventParam> input) {
                DHCompatInternal instance = LodRendererEvents.getInstance();
                if (instance.shouldOverride) {
                    Vec3f modelPos = ((DhApiBeforeBufferRenderEvent.EventParam)input.value).modelPos;
                    if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                        instance.getShadowShader().bind();
                        instance.getShadowShader().setModelPos(modelPos);
                    } else if (atTranslucent) {
                        instance.getTranslucentShader().bind();
                        instance.getTranslucentShader().setModelPos(modelPos);
                    } else {
                        instance.getSolidShader().bind();
                        instance.getSolidShader().setModelPos(modelPos);
                    }
                }
            }
        };
        DhApi.events.bind(DhApiBeforeBufferRenderEvent.class, (IBindable)beforeCleanupEvent);
    }

    private static void setupBeforeRenderFrameBufferBinding() {
        DhApiBeforeRenderSetupEvent beforeRenderPassEvent = new DhApiBeforeRenderSetupEvent(){

            public void beforeSetup(DhApiEventParam<DhApiRenderParam> event) {
                DHCompatInternal instance = LodRendererEvents.getInstance();
                OverrideInjector.INSTANCE.unbind(IDhApiShadowCullingFrustum.class, (IDhApiOverrideable)ShadowRenderer.FRUSTUM);
                OverrideInjector.INSTANCE.unbind(IDhApiFramebuffer.class, (IDhApiOverrideable)instance.getShadowFBWrapper());
                OverrideInjector.INSTANCE.unbind(IDhApiFramebuffer.class, (IDhApiOverrideable)instance.getSolidFBWrapper());
                if (instance.shouldOverride) {
                    if (ShadowRenderingState.areShadowsCurrentlyBeingRendered() && instance.shouldOverrideShadow) {
                        OverrideInjector.INSTANCE.bind(IDhApiFramebuffer.class, (IDhApiOverrideable)instance.getShadowFBWrapper());
                        OverrideInjector.INSTANCE.bind(IDhApiShadowCullingFrustum.class, (IDhApiOverrideable)ShadowRenderer.FRUSTUM);
                    } else {
                        OverrideInjector.INSTANCE.bind(IDhApiFramebuffer.class, (IDhApiOverrideable)instance.getSolidFBWrapper());
                    }
                }
            }
        };
        DhApi.events.bind(DhApiBeforeRenderSetupEvent.class, (IBindable)beforeRenderPassEvent);
    }

    private static void setupBeforeRenderPassEvent() {
        DhApiBeforeRenderPassEvent beforeCleanupEvent = new DhApiBeforeRenderPassEvent(){

            public void beforeRender(DhApiEventParam<DhApiRenderParam> event) {
                float partialTicks;
                DHCompatInternal instance = LodRendererEvents.getInstance();
                if (instance.shouldOverride) {
                    DhApi.Delayed.configs.graphics().ambientOcclusion().enabled().setValue((Object)false);
                    DhApi.Delayed.configs.graphics().fog().drawMode().setValue((Object)EDhApiFogDrawMode.FOG_DISABLED);
                    if (((DhApiRenderParam)event.value).renderPass == EDhApiRenderPass.OPAQUE_AND_TRANSPARENT) {
                        Iris.logger.error("Unexpected; somehow the Opaque + Translucent pass ran with shaders on.");
                    }
                } else {
                    DhApi.Delayed.configs.graphics().ambientOcclusion().enabled().clearValue();
                    DhApi.Delayed.configs.graphics().fog().drawMode().clearValue();
                }
                if (((DhApiRenderParam)event.value).renderPass == EDhApiRenderPass.OPAQUE && instance.shouldOverride) {
                    if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                        instance.getShadowShader().bind();
                    } else {
                        instance.getSolidShader().bind();
                    }
                    atTranslucent = false;
                }
                if (((DhApiRenderParam)event.value).renderPass == EDhApiRenderPass.OPAQUE) {
                    partialTicks = ((DhApiRenderParam)event.value).partialTicks;
                    if (instance.shouldOverride) {
                        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                            instance.getShadowShader().fillUniformData(ShadowRenderer.PROJECTION, ShadowRenderer.MODELVIEW, -1000, partialTicks);
                        } else {
                            Matrix4f projection = CapturedRenderingState.INSTANCE.getGbufferProjection();
                            instance.getSolidShader().fillUniformData(new Matrix4f().setPerspective(projection.perspectiveFov(), projection.m11() / projection.m00(), ((DhApiRenderParam)event.value).nearClipPlane, ((DhApiRenderParam)event.value).farClipPlane), CapturedRenderingState.INSTANCE.getGbufferModelView(), -1000, partialTicks);
                        }
                    }
                }
                if (((DhApiRenderParam)event.value).renderPass == EDhApiRenderPass.TRANSPARENT) {
                    partialTicks = ((DhApiRenderParam)event.value).partialTicks;
                    int depthTextureId = (Integer)DhApi.Delayed.renderProxy.getDhDepthTextureId().payload;
                    if (instance.shouldOverrideShadow && ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
                        instance.getShadowShader().bind();
                        instance.getShadowFB().bind();
                        atTranslucent = true;
                        return;
                    }
                    if (instance.shouldOverride && instance.getTranslucentFB() != null) {
                        instance.copyTranslucents(textureWidth, textureHeight);
                        instance.getTranslucentShader().bind();
                        Matrix4f projection = CapturedRenderingState.INSTANCE.getGbufferProjection();
                        GL46C.glDisable((int)2884);
                        instance.getTranslucentShader().fillUniformData(new Matrix4f().setPerspective(projection.perspectiveFov(), projection.m11() / projection.m00(), ((DhApiRenderParam)event.value).nearClipPlane, ((DhApiRenderParam)event.value).farClipPlane), CapturedRenderingState.INSTANCE.getGbufferModelView(), -1000, partialTicks);
                        instance.getTranslucentFB().bind();
                    }
                    atTranslucent = true;
                }
            }
        };
        DhApi.events.bind(DhApiBeforeRenderPassEvent.class, (IBindable)beforeCleanupEvent);
    }

    private static void setupBeforeApplyShaderEvent() {
        DhApiBeforeApplyShaderRenderEvent beforeApplyShaderEvent = new DhApiBeforeApplyShaderRenderEvent(){

            public void beforeRender(DhApiCancelableEventParam<DhApiRenderParam> event) {
                if (IrisApi.getInstance().isShaderPackInUse()) {
                    DHCompatInternal instance = LodRendererEvents.getInstance();
                    OverrideInjector.INSTANCE.unbind(IDhApiShadowCullingFrustum.class, (IDhApiOverrideable)ShadowRenderer.FRUSTUM);
                    OverrideInjector.INSTANCE.unbind(IDhApiFramebuffer.class, (IDhApiOverrideable)instance.getShadowFBWrapper());
                    OverrideInjector.INSTANCE.unbind(IDhApiFramebuffer.class, (IDhApiOverrideable)instance.getSolidFBWrapper());
                    event.cancelEvent();
                }
            }
        };
        DhApi.events.bind(DhApiBeforeApplyShaderRenderEvent.class, (IBindable)beforeApplyShaderEvent);
    }
}

