/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.ai;

import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathResult;
import com.github.alexthe666.iceandfire.world.MyrmexWorldData;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.LevelAccessor;

public class MyrmexAIReEnterHive
extends Goal {
    private final EntityMyrmexBase myrmex;
    private final double movementSpeed;
    private PathResult path;
    private BlockPos currentTarget = BlockPos.f_121853_;
    private Phases currentPhase = Phases.GOTOENTRANCE;
    private MyrmexHive hive;

    public MyrmexAIReEnterHive(EntityMyrmexBase entityIn, double movementSpeedIn) {
        this.myrmex = entityIn;
        this.movementSpeed = movementSpeedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.myrmex.canMove() || this.myrmex.shouldLeaveHive() || !this.myrmex.shouldEnterHive() || this.currentPhase != Phases.GOTOENTRANCE) {
            return false;
        }
        MyrmexHive village = this.myrmex.getHive();
        if (village == null) {
            village = MyrmexWorldData.get(this.myrmex.m_9236_()).getNearestHive(this.myrmex.m_20183_(), 500);
        }
        if (!(this.myrmex.m_21573_() instanceof AdvancedPathNavigate) || this.myrmex.m_20159_()) {
            return false;
        }
        if (village == null || this.myrmex.isInHive()) {
            return false;
        }
        this.hive = village;
        this.currentTarget = MyrmexHive.getGroundedPos((LevelAccessor)this.myrmex.m_9236_(), this.hive.getClosestEntranceToEntity((Entity)this.myrmex, this.myrmex.m_217043_(), false));
        this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ(this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_(), 1.0);
        this.currentPhase = Phases.GOTOENTRANCE;
        return this.path != null;
    }

    public void m_8037_() {
        if (this.currentPhase == Phases.GOTOENTRANCE && !this.myrmex.pathReachesTarget(this.path, this.currentTarget, 12.0)) {
            this.currentTarget = MyrmexHive.getGroundedPos((LevelAccessor)this.myrmex.m_9236_(), this.hive.getClosestEntranceToEntity((Entity)this.myrmex, this.myrmex.m_217043_(), true));
            this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ(this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_(), this.movementSpeed);
        }
        if (this.currentPhase == Phases.GOTOENTRANCE && this.myrmex.isCloseEnoughToTarget(this.currentTarget, 12.0) && this.hive != null) {
            this.currentTarget = this.hive.getClosestEntranceBottomToEntity((Entity)this.myrmex, this.myrmex.m_217043_());
            this.currentPhase = Phases.GOTOEXIT;
            this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ(this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_(), 1.0);
        }
        if (this.currentPhase == Phases.GOTOEXIT && this.myrmex.isCloseEnoughToTarget(this.currentTarget, 12.0) && this.hive != null) {
            this.currentTarget = MyrmexHive.getGroundedPos((LevelAccessor)this.myrmex.m_9236_(), this.hive.getCenter());
            this.currentPhase = Phases.GOTOCENTER;
            this.path = ((AdvancedPathNavigate)this.myrmex.m_21573_()).moveToXYZ(this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_(), 1.0);
        }
        this.myrmex.isEnteringHive = !this.myrmex.isCloseEnoughToTarget(this.currentTarget, 14.0) && this.currentPhase != Phases.GOTOCENTER;
    }

    public boolean m_8045_() {
        return !this.myrmex.isCloseEnoughToTarget(this.currentTarget, 9.0) || this.currentPhase == Phases.GOTOCENTER;
    }

    public void m_8041_() {
        this.currentTarget = BlockPos.f_121853_;
        this.currentPhase = Phases.GOTOENTRANCE;
    }

    private static enum Phases {
        GOTOENTRANCE,
        GOTOEXIT,
        GOTOCENTER;

    }
}

