/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.spell.game;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import dev.xkmc.youkaishomecoming.content.entity.boss.KoishiEntity;
import dev.xkmc.youkaishomecoming.content.entity.boss.SanaeEntity;
import dev.xkmc.youkaishomecoming.content.entity.boss.YukariEntity;
import dev.xkmc.youkaishomecoming.content.entity.fairy.CirnoEntity;
import dev.xkmc.youkaishomecoming.content.entity.reimu.MaidenEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.GeneralYoukaiEntity;
import dev.xkmc.youkaishomecoming.content.spell.game.cirno.CirnoIceStorm;
import dev.xkmc.youkaishomecoming.content.spell.game.koishi.AncestorDream;
import dev.xkmc.youkaishomecoming.content.spell.game.reimu.StagedHoming;
import dev.xkmc.youkaishomecoming.content.spell.game.sanae.Sugiruyoru;
import dev.xkmc.youkaishomecoming.content.spell.game.youmu.YoumuSlash;
import dev.xkmc.youkaishomecoming.content.spell.game.yukari.YukariMain;
import dev.xkmc.youkaishomecoming.content.spell.game.yuyuko.YuyukoTest;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.ListSpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCard;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCardWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;

public class TouhouSpellCards {
    private static final Map<String, Supplier<SpellCard>> MAP = new ConcurrentHashMap<String, Supplier<SpellCard>>();

    public static void registerSpell(String id, Supplier<SpellCard> card) {
        MAP.put(id, card);
    }

    public static void registerSpells() {
        TouhouSpellCards.registerSpell("touhou_little_maid:hakurei_reimu", StagedHoming::new);
        TouhouSpellCards.registerSpell("touhou_little_maid:yukari_yakumo", YukariMain::new);
        TouhouSpellCards.registerSpell("touhou_little_maid:cirno", CirnoIceStorm::new);
        TouhouSpellCards.registerSpell("touhou_little_maid:kochiya_sanae", Sugiruyoru::new);
        TouhouSpellCards.registerSpell("touhou_little_maid:komeiji_koishi", AncestorDream::new);
        TouhouSpellCards.registerSpell("touhou_little_maid:konpaku_youmu", () -> ListSpellCard.of(new YoumuSlash()));
        TouhouSpellCards.registerSpell("touhou_little_maid:saigyouji_yuyuko", () -> ListSpellCard.of(new YuyukoTest()));
    }

    public static void setSpell(GeneralYoukaiEntity e, String id) {
        e.spellCard = new SpellCardWrapper();
        e.spellCard.modelId = id;
        Supplier<SpellCard> sup = MAP.get(id);
        if (sup != null) {
            e.spellCard.card = sup.get();
        }
        e.syncModel();
        if (ModList.get().isLoaded("touhou_little_maid")) {
            ResourceLocation rl = new ResourceLocation(id);
            MutableComponent name = Component.m_237115_((String)(rl.m_214296_("model") + ".name"));
            MutableComponent desc = Component.m_237115_((String)(rl.m_214296_("model") + ".desc"));
            e.m_6593_((Component)name.m_130946_(" - ").m_7220_((Component)desc));
        }
    }

    public static void setReimu(MaidenEntity e) {
        TouhouSpellCards.setSpell(e, "touhou_little_maid:hakurei_reimu");
        if (ModList.get().isLoaded("touhou_little_maid")) {
            e.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)InitItems.HAKUREI_GOHEI.get(), 1));
        }
    }

    public static void setCirno(CirnoEntity e) {
        TouhouSpellCards.setSpell(e, "touhou_little_maid:cirno");
    }

    public static void setYukari(YukariEntity e) {
        TouhouSpellCards.setSpell(e, "touhou_little_maid:yukari_yakumo");
    }

    public static void setSanae(SanaeEntity e) {
        TouhouSpellCards.setSpell(e, "touhou_little_maid:kochiya_sanae");
    }

    public static void setKoishi(KoishiEntity e) {
        TouhouSpellCards.setSpell(e, "touhou_little_maid:komeiji_koishi");
    }
}

