/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.capability;

import dev.xkmc.l2library.capability.entity.GeneralCapabilityHolder;
import dev.xkmc.l2library.capability.entity.GeneralCapabilityTemplate;
import dev.xkmc.l2serial.network.SimplePacketBase;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.capability.FrogSyncPacket;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.registrate.YHItems;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

@SerialClass
public class FrogGodCapability
extends GeneralCapabilityTemplate<Frog, FrogGodCapability> {
    public static final Capability<FrogGodCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<FrogGodCapability>(){});
    public static final GeneralCapabilityHolder<Frog, FrogGodCapability> HOLDER = new GeneralCapabilityHolder(YoukaisHomecoming.loc("frog_god"), CAPABILITY, FrogGodCapability.class, FrogGodCapability::new, Frog.class, e -> true);
    @SerialClass.SerialField(toClient=true)
    public boolean hasHat;
    @SerialClass.SerialField
    private final LinkedHashSet<EntityType<?>> eaten = new LinkedHashSet();

    public static void register() {
    }

    public void syncToClient(LivingEntity entity) {
        YoukaisHomecoming.HANDLER.toTrackingPlayers((SimplePacketBase)new FrogSyncPacket(entity, this), (Entity)entity);
    }

    public void eat(Frog frog, Entity other) {
        if (!this.hasHat) {
            return;
        }
        EntityType type = other.m_6095_();
        if (!type.m_204039_(EntityTypeTags.f_13121_)) {
            return;
        }
        int noSight = (Integer)YHModConfig.COMMON.frogEatRaiderVillagerNoSightRange.get();
        int sight = (Integer)YHModConfig.COMMON.frogEatRaiderVillagerSightRange.get();
        AABB aabb = frog.m_20191_().m_82400_((double)noSight);
        List list = frog.m_9236_().m_142425_(EntityTypeTest.m_156916_(Villager.class), aabb, e -> e.m_142582_((Entity)frog) || e.m_142582_(other) || e.m_20270_((Entity)frog) < (float)sight);
        if (list.isEmpty()) {
            return;
        }
        this.eaten.add(type);
        if (this.eaten.size() >= (Integer)YHModConfig.COMMON.frogEatCountForHat.get()) {
            this.eaten.clear();
            this.hasHat = false;
            this.syncToClient((LivingEntity)frog);
            frog.m_19998_((ItemLike)YHItems.SUWAKO_HAT.get());
        }
    }

    public static boolean canEatSpecial(Frog frog, LivingEntity target) {
        if (HOLDER.isProper((ICapabilityProvider)frog)) {
            FrogGodCapability cap = (FrogGodCapability)HOLDER.get((ICapabilityProvider)frog);
            return cap.hasHat && target.m_6095_().m_204039_(EntityTypeTags.f_13121_);
        }
        return false;
    }

    public static boolean hasHat(Frog frog) {
        if (HOLDER.isProper((ICapabilityProvider)frog)) {
            FrogGodCapability cap = (FrogGodCapability)HOLDER.get((ICapabilityProvider)frog);
            return cap.hasHat;
        }
        return false;
    }

    public static void onEatTarget(Frog frog, Entity instance) {
        if (HOLDER.isProper((ICapabilityProvider)frog)) {
            FrogGodCapability cap = (FrogGodCapability)HOLDER.get((ICapabilityProvider)frog);
            cap.eat(frog, instance);
        }
    }

    public static void startTracking(Frog frog, Player entity) {
        if (HOLDER.isProper((ICapabilityProvider)frog)) {
            FrogGodCapability cap = (FrogGodCapability)HOLDER.get((ICapabilityProvider)frog);
            YoukaisHomecoming.HANDLER.toClientPlayer((SimplePacketBase)new FrogSyncPacket((LivingEntity)frog, cap), (ServerPlayer)entity);
        }
    }
}

