/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.variants;

import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.youkaishomecoming.content.block.variants.TemplateModelHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class ThinDoorBlock
extends DoorBlock {
    protected static final float TH = 1.0f;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);

    public ThinDoorBlock(BlockBehaviour.Properties pProperties, BlockSetType pType) {
        super(pProperties, pType);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)f_52726_);
        boolean close = (Boolean)pState.m_61143_((Property)f_52727_) == false;
        boolean rightHinge = pState.m_61143_((Property)f_52728_) == DoorHingeSide.RIGHT;
        return switch (direction) {
            default -> {
                if (close) {
                    yield EAST_AABB;
                }
                if (rightHinge) {
                    yield NORTH_AABB;
                }
                yield SOUTH_AABB;
            }
            case Direction.SOUTH -> {
                if (close) {
                    yield SOUTH_AABB;
                }
                if (rightHinge) {
                    yield EAST_AABB;
                }
                yield WEST_AABB;
            }
            case Direction.WEST -> {
                if (close) {
                    yield WEST_AABB;
                }
                if (rightHinge) {
                    yield SOUTH_AABB;
                }
                yield NORTH_AABB;
            }
            case Direction.NORTH -> close ? NORTH_AABB : (rightHinge ? WEST_AABB : EAST_AABB);
        };
    }

    public static void buildModels(RegistrateBlockstateProvider pvd, DoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation top) {
        TemplateModelHandler models = new TemplateModelHandler(pvd.models());
        Object bottomLeft = models.doorBottomLeft(baseName + "_bottom_left", bottom, top);
        Object bottomLeftOpen = models.doorBottomLeftOpen(baseName + "_bottom_left_open", bottom, top);
        Object bottomRight = models.doorBottomRight(baseName + "_bottom_right", bottom, top);
        Object bottomRightOpen = models.doorBottomRightOpen(baseName + "_bottom_right_open", bottom, top);
        Object topLeft = models.doorTopLeft(baseName + "_top_left", bottom, top);
        Object topLeftOpen = models.doorTopLeftOpen(baseName + "_top_left_open", bottom, top);
        Object topRight = models.doorTopRight(baseName + "_top_right", bottom, top);
        Object topRightOpen = models.doorTopRightOpen(baseName + "_top_right_open", bottom, top);
        ThinDoorBlock.doorBlock(pvd, block, bottomLeft, bottomLeftOpen, bottomRight, bottomRightOpen, topLeft, topLeftOpen, topRight, topRightOpen);
    }

    public static void doorBlock(RegistrateBlockstateProvider pvd, DoorBlock block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        pvd.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            boolean lower;
            int yRot = (int)((Direction)state.m_61143_((Property)DoorBlock.f_52726_)).m_122435_() + 90;
            boolean right = state.m_61143_((Property)DoorBlock.f_52728_) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)DoorBlock.f_52727_);
            boolean bl = lower = state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER;
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            if (lower && right && open) {
                model = bottomRightOpen;
            } else if (lower && !right && open) {
                model = bottomLeftOpen;
            }
            if (lower && right && !open) {
                model = bottomRight;
            } else if (lower && !right && !open) {
                model = bottomLeft;
            }
            if (!lower && right && open) {
                model = topRightOpen;
            } else if (!lower && !right && open) {
                model = topLeftOpen;
            }
            if (!lower && right && !open) {
                model = topRight;
            } else if (!(lower || right || open)) {
                model = topLeft;
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new Property[]{DoorBlock.f_52729_});
    }
}

