/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.integration.jei;

import de.teamlapen.vampirism.core.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.grid.vampiresdelight.common.registry.VDItems;
import net.grid.vampiresdelight.common.utility.VDTextUtils;
import net.grid.vampiresdelight.integration.jei.VDJEIRecipeTypes;
import net.grid.vampiresdelight.integration.jei.category.VDJEIPouringRecipeCategory;
import net.grid.vampiresdelight.integration.jei.resource.VDJEIPouringRecipe;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class VDJEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("vampiresdelight", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new VDJEIPouringRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        VDJEIPouringRecipe[] recipes = new VDJEIPouringRecipe[]{new VDJEIPouringRecipe(new ItemStack((ItemLike)VDItems.BLOOD_WINE_BOTTLE.get()), new ItemStack((ItemLike)VDItems.BLOOD_WINE_GLASS.get()), new ItemStack((ItemLike)Items.f_42590_)), new VDJEIPouringRecipe(new ItemStack((ItemLike)VDItems.DANDELION_BEER_BOTTLE.get()), new ItemStack((ItemLike)VDItems.DANDELION_BEER_MUG.get()), new ItemStack((ItemLike)Items.f_42590_))};
        registration.addRecipes(VDJEIRecipeTypes.POURING, new ArrayList<VDJEIPouringRecipe>(Arrays.asList(recipes)));
        VDJEIPlugin.registerSingleIngredientInfo((Item)VDItems.HUMAN_EYE.get(), registration);
        VDJEIPlugin.registerSingleIngredientInfo((Item)VDItems.BLACK_MUSHROOM.get(), registration);
        VDJEIPlugin.registerSingleIngredientInfo((Item)VDItems.SILVER_KNIFE.get(), TextUtils.getTranslation((String)"jei.info.knife", (Object[])new Object[0]), registration);
        VDJEIPlugin.registerMultipleIngredientInfo(List.of(new ItemStack((ItemLike)VDItems.WILD_GARLIC.get()), new ItemStack((ItemLike)ModItems.ITEM_GARLIC.get())), registration);
    }

    private static void registerSingleIngredientInfo(Item item, IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{VDTextUtils.getTranslation("jei.info." + ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), new Object[0])});
    }

    private static void registerSingleIngredientInfo(Item item, MutableComponent translation, IRecipeRegistration registration) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{translation});
    }

    private static void registerMultipleIngredientInfo(List<ItemStack> items, IRecipeRegistration registration) {
        registration.addIngredientInfo(items, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{VDTextUtils.getTranslation("jei.info." + ForgeRegistries.ITEMS.getKey((Object)items.get(0).m_41720_()).m_135815_(), new Object[0])});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)VDItems.DARK_STONE_STOVE.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)VDItems.BLOOD_WINE_BOTTLE.get()), new RecipeType[]{VDJEIRecipeTypes.POURING});
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

