/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common.block;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.grid.vampiresdelight.common.item.PourableBottleItem;
import net.grid.vampiresdelight.common.registry.VDSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlacedPourableBottleBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty SERVINGS = IntegerProperty.m_61631_((String)"servings", (int)0, (int)64);
    public static final VoxelShape SHAPE_1 = Stream.of(Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)11.0, (double)10.5), Block.m_49796_((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private final Supplier<PourableBottleItem> bottleItem;
    private final VoxelShape shape;

    public PlacedPourableBottleBlock(MapColor mapColor, Supplier<PourableBottleItem> bottleItem, VoxelShape shape) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_284180_(mapColor).m_60966_().m_60955_().m_278166_(PushReaction.DESTROY));
        this.bottleItem = bottleItem;
        this.shape = shape;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(0)));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pStack.m_41720_() instanceof PourableBottleItem) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)SERVINGS, (Comparable)Integer.valueOf(pStack.m_41773_())), 2);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.f_46443_ && pPlayer.m_6047_()) {
            ItemStack itemStack = this.getBottleStack(pState);
            if (pPlayer.m_21120_(pHand).m_41619_()) {
                pPlayer.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            } else {
                PlacedPourableBottleBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)itemStack);
            }
            pLevel.m_5594_(null, pPos, pState.m_60734_().getSoundType(pState, (LevelReader)pLevel, pPos, (Entity)pPlayer).m_56777_(), SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_7471_(pPos, false);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        return List.of(this.getBottleStack(pState));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getBottleStack(state);
    }

    public ItemStack getBottleStack(BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)this.bottleItem.get());
        itemStack.m_41721_(((Integer)state.m_61143_((Property)SERVINGS)).intValue());
        return itemStack;
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        BlockPos blockPos = pHit.m_82425_();
        if (!pLevel.f_46443_ && pProjectile.m_142265_(pLevel, blockPos)) {
            pLevel.m_5594_(null, blockPos, (SoundEvent)VDSounds.BOTTLE_BREAKS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            pLevel.m_46961_(blockPos, true);
        }
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{WATERLOGGED, SERVINGS});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape;
    }
}

