/*
 * Decompiled with CFR 0.152.
 */
package net.grid.vampiresdelight.common;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;

public class VDConfiguration {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec CLIENT_CONFIG;
    public static final String CATEGORY_VILLAGE = "village";
    public static final ForgeConfigSpec.BooleanValue FARMERS_BUY_GARLIC;
    public static final ForgeConfigSpec.BooleanValue WANDERING_TRADER_SELLS_VAMPIRISM_ITEMS;
    public static final String CATEGORY_BLOCKS = "blocks";
    public static final ForgeConfigSpec.DoubleValue BLOODY_SOIL_BOOST_CHANCE;
    public static final String CATEGORY_ITEMS = "items";
    public static final ForgeConfigSpec.BooleanValue ALCHEMICAL_COCKTAIL_BURNS_GROUND;
    public static final ForgeConfigSpec.DoubleValue ALCHEMICAL_COCKTAIL_SPLASH_RADIUS;
    public static final ForgeConfigSpec.IntValue ALCHEMICAL_COCKTAIL_STACK_SIZE;
    public static final String CATEGORY_EFFECTS = "effects";
    public static final ForgeConfigSpec.BooleanValue REPLACE_WEIRD_JELLY_SUNSCREEN_WITH_JUMPBOOST;
    public static final ForgeConfigSpec.BooleanValue BAT_MEAT_WITHERS_HUMANS;
    public static final ForgeConfigSpec.BooleanValue BLESSING_HELPS_AGAINST_GHOSTS;
    public static final ForgeConfigSpec.BooleanValue ARMOR_DISSOLVES_FULLY;
    public static final String CATEGORY_ENCHANTMENTS = "enchantments";
    public static final ForgeConfigSpec.BooleanValue BACKSTABBING_CAN_BE_APPLIED_TO_HUNTER_WEAPON;
    public static final ForgeConfigSpec.DoubleValue VAMPIRE_BITE_MAX_HEALING_VALUE;
    public static final ForgeConfigSpec.IntValue VAMPIRE_BITE_HEALING_CHANCE_1;
    public static final ForgeConfigSpec.IntValue VAMPIRE_BITE_HEALING_CHANCE_2;
    public static final ForgeConfigSpec.IntValue VAMPIRE_BITE_HEALING_CHANCE_3;
    public static final ForgeConfigSpec.BooleanValue DISABLE_VAMPIRE_BITE;
    public static final String CATEGORY_WORLD = "world";
    public static final ForgeConfigSpec.BooleanValue GENERATE_VD_CHEST_LOOT;
    public static final ForgeConfigSpec.BooleanValue GENERATE_COOKING_POT_IN_HUNTER_CAMP;
    public static final ForgeConfigSpec.BooleanValue GENERATE_COOKING_POT_NEAR_HUNTER_CAMP;
    public static final ForgeConfigSpec.IntValue COOKING_POT_IN_HUNTER_CAMP_CHANCE;
    public static final String CATEGORY_TOOLTIPS = "tooltips";
    public static final ForgeConfigSpec.BooleanValue HUNTER_TOOLTIPS_FOR_EVERYONE;
    public static final ForgeConfigSpec.BooleanValue COLORED_TOOLTIPS;
    public static final String CATEGORY_TOOLTIP_COLORS = "tooltip_colors";
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> VAMPIRE_FOOD_TOOLTIP_START_COLOR;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> VAMPIRE_FOOD_TOOLTIP_END_COLOR;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> HUNTER_FOOD_TOOLTIP_START_COLOR;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> HUNTER_FOOD_TOOLTIP_END_COLOR;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> WEREWOLF_FOOD_TOOLTIP_START_COLOR;
    public static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> WEREWOLF_FOOD_TOOLTIP_END_COLOR;
    public static final String CATEGORY_APPLESKIN = "appleskin";
    public static final ForgeConfigSpec.BooleanValue CORRECT_APPLE_SKIN_TOOLTIPS;
    public static final ForgeConfigSpec.BooleanValue HIDE_APPLE_SKIN_HUMAN_FOOD_TOOLTIPS_FOR_VAMPIRES;
    public static final ForgeConfigSpec.BooleanValue HIDE_APPLE_SKIN_HUMAN_FOOD_TOOLTIPS_FOR_WEREWOLVES;

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("Common settings");
        COMMON_BUILDER.comment("Village").push(CATEGORY_VILLAGE);
        FARMERS_BUY_GARLIC = COMMON_BUILDER.comment("Should Farmers buy garlic? (May reduce chances of other trades appearing)").define("farmersBuyGarlic", true);
        WANDERING_TRADER_SELLS_VAMPIRISM_ITEMS = COMMON_BUILDER.comment("Should the Wandering Trader sell some of vampirism's and this mod's items? (Including seeds and some blocks)").define("wanderingTraderSellsVampirismItems", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Blocks").push(CATEGORY_BLOCKS);
        BLOODY_SOIL_BOOST_CHANCE = COMMON_BUILDER.comment("How often (in percentage) should Bloody Soil succeed in boosting a plant's growth at each random tick? Set it to 0.0 to disable this.").defineInRange("bloodySoilBoostChance", 0.2, 0.0, 1.0);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Items").push(CATEGORY_ITEMS);
        ALCHEMICAL_COCKTAIL_BURNS_GROUND = COMMON_BUILDER.comment("Should the Alchemical Cocktail burn ground when thrown? Recommended to set this to \"false\" on servers with claims.").define("alchemicalCocktailBurnsGround", true);
        ALCHEMICAL_COCKTAIL_SPLASH_RADIUS = COMMON_BUILDER.comment("What should be the radius of Alchemical Cocktail fire splash?").defineInRange("alchemicalCocktailSplashRadius", 3.5, 1.0, 99.0);
        ALCHEMICAL_COCKTAIL_STACK_SIZE = COMMON_BUILDER.comment("What should be the maximum stack size of the Alchemical Cocktail?").defineInRange("alchemicalCocktailStackSize", 8, 1, 64);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Effects").push(CATEGORY_EFFECTS);
        REPLACE_WEIRD_JELLY_SUNSCREEN_WITH_JUMPBOOST = COMMON_BUILDER.comment("Should the weird jelly Sunscreen effect be replaced with Jump Boost?").define("replaceWeirdJellySunscreenWithJumpboost", false);
        BAT_MEAT_WITHERS_HUMANS = COMMON_BUILDER.comment("Should the bat meat and food made of it have chance of giving Wither effect when eaten by humans?").define("batMeatWithersHumans", true);
        BLESSING_HELPS_AGAINST_GHOSTS = COMMON_BUILDER.comment("Should the blessing effect banish ghosts just like phantoms?").define("blessingHelpsAgainstGhosts", true);
        ARMOR_DISSOLVES_FULLY = COMMON_BUILDER.comment("Should 'weak' armor such as leather and chain dissolve fully because of Clothes Dissolving effect?").define("armorDissolvesFully", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Enchantments").push(CATEGORY_ENCHANTMENTS);
        BACKSTABBING_CAN_BE_APPLIED_TO_HUNTER_WEAPON = COMMON_BUILDER.comment("Should it be possible to apply Backstabbing enchantment to some hunter axes and stakes?").define("backstabbingCanBeAppliedToHunterWeapon", true);
        VAMPIRE_BITE_MAX_HEALING_VALUE = COMMON_BUILDER.comment("What should be the maximum amount of hearts that Vampire Bite enchantment should heal?").defineInRange("vampireBiteMaxHealingValue", 1.5, 0.5, 10.0);
        VAMPIRE_BITE_HEALING_CHANCE_1 = COMMON_BUILDER.comment("With what chance should Vampire Bite enchantment regenerate health?").defineInRange("vampireBiteChanceLevel1", 20, 1, 100);
        VAMPIRE_BITE_HEALING_CHANCE_2 = COMMON_BUILDER.defineInRange("vampireBiteChanceLevel2", 25, 1, 100);
        VAMPIRE_BITE_HEALING_CHANCE_3 = COMMON_BUILDER.defineInRange("vampireBiteChanceLevel3", 30, 1, 100);
        DISABLE_VAMPIRE_BITE = COMMON_BUILDER.comment("Should Vampire Bite enchantment be disabled?").comment("It won't be removed from the game, but it'll be impossible to apply it to tools and it won't heal the player.").define("disableVampireBite", false);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("World generation").push(CATEGORY_WORLD);
        GENERATE_VD_CHEST_LOOT = COMMON_BUILDER.comment("Should this mod add some of its items as extra chest loot across Minecraft and Vampirism structures?").define("generateVDChestLoot", true);
        GENERATE_COOKING_POT_IN_HUNTER_CAMP = COMMON_BUILDER.comment("Should a Cooking Pot on a Campfire be generated in hunter camps?").define("generateCookingPotInHunterCamp", true);
        GENERATE_COOKING_POT_NEAR_HUNTER_CAMP = COMMON_BUILDER.comment("Should a Cooking Pot be generated on the campfire near hunter camps? By default it's generated on the fireplace in the middle of it.").define("generateCookingPotNearHunterCamp", false);
        COOKING_POT_IN_HUNTER_CAMP_CHANCE = COMMON_BUILDER.comment("With what chance should a Cooking Pot on a Campfire be generated in hunter camps? It doesn't mean that it'll spawn with this chance in every camp, but the ones with crafting table or hunter table.").defineInRange("cookingPotInHunterCampSpawnChance", 60, 1, 100);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
        ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
        CLIENT_BUILDER.comment("Client settings");
        CLIENT_BUILDER.comment("Tooltips").push(CATEGORY_TOOLTIPS);
        COLORED_TOOLTIPS = CLIENT_BUILDER.comment("Should the mod change the color of tooltips?").define("coloredTooltips", true);
        HUNTER_TOOLTIPS_FOR_EVERYONE = CLIENT_BUILDER.comment("Should hunter food tooltips and tooltip's color be shown to all fractions? (Only shown to vampires by default)").define("hunterTooltipsForEveryone", false);
        CLIENT_BUILDER.comment("Colors of tooltips").push(CATEGORY_TOOLTIP_COLORS);
        VAMPIRE_FOOD_TOOLTIP_START_COLOR = CLIENT_BUILDER.comment("What color (rgb) should be used for vampire food tooltips as the start color? (The shade it starts with)").comment("Default: 124, 40, 124").defineList("vampireFoodTooltipStartColor", (List)ImmutableList.of((Object)124, (Object)40, (Object)124), (Predicate)new ConfigTypePredicate(Integer.class));
        VAMPIRE_FOOD_TOOLTIP_END_COLOR = CLIENT_BUILDER.comment("What color (rgb) should be used for vampire food tooltips as the end color? (The shade it ends with)").comment("Default: 50, 0, 70").defineList("vampireFoodTooltipEndColor", (List)ImmutableList.of((Object)50, (Object)0, (Object)70), (Predicate)new ConfigTypePredicate(Integer.class));
        HUNTER_FOOD_TOOLTIP_START_COLOR = CLIENT_BUILDER.comment("What color (rgb) should be used for hunter food tooltips as the start color? (The shade it starts with)").comment("Default: 65, 65, 220").defineList("hunterFoodTooltipStartColor", (List)ImmutableList.of((Object)65, (Object)65, (Object)220), (Predicate)new ConfigTypePredicate(Integer.class));
        HUNTER_FOOD_TOOLTIP_END_COLOR = CLIENT_BUILDER.comment("What color (rgb) should be used for hunter food tooltips as the end color? (The shade it ends with)").comment("Default: 30, 30, 90").defineList("hunterFoodTooltipEndColor", (List)ImmutableList.of((Object)30, (Object)30, (Object)90), (Predicate)new ConfigTypePredicate(Integer.class));
        WEREWOLF_FOOD_TOOLTIP_START_COLOR = CLIENT_BUILDER.comment("What color (rgb) should be used for werewolf food tooltips as the start color? (Werewolves mod only) (The shade it starts with)").comment("Default: 250, 135, 0").defineList("werewolfFoodTooltipStartColor", (List)ImmutableList.of((Object)250, (Object)135, (Object)0), (Predicate)new ConfigTypePredicate(Integer.class));
        WEREWOLF_FOOD_TOOLTIP_END_COLOR = CLIENT_BUILDER.comment("What color (rgb) should be used for werewolf food tooltips as the end color? (Werewolves mod only) (The shade it ends with)").comment("Default: 115, 45, 0").defineList("werewolfFoodTooltipEndColor", (List)ImmutableList.of((Object)115, (Object)45, (Object)0), (Predicate)new ConfigTypePredicate(Integer.class));
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("AppleSkin").push(CATEGORY_APPLESKIN);
        CORRECT_APPLE_SKIN_TOOLTIPS = CLIENT_BUILDER.comment("Should AppleSkin tooltips' food values be fixed depending on player's race? (In case the player is a vampire, it'll show blood values for vampire food)").define("correctAppleSkinTooltips", true);
        HIDE_APPLE_SKIN_HUMAN_FOOD_TOOLTIPS_FOR_VAMPIRES = CLIENT_BUILDER.comment("Should AppleSkin tooltips be hidden for human food if the player is a vampire?").define("hideAppleSkinHumanFoodTooltipsForVampires", true);
        HIDE_APPLE_SKIN_HUMAN_FOOD_TOOLTIPS_FOR_WEREWOLVES = CLIENT_BUILDER.comment("Should AppleSkin tooltips be hidden if the player is a werewolf for food they can't eat?").define("hideAppleSkinHumanFoodTooltipsForWerewolves", true);
        CLIENT_BUILDER.pop();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }

    private record ConfigTypePredicate(Class configType) implements Predicate<Object>
    {
        @Override
        public boolean test(Object o) {
            return this.configType.isInstance(o);
        }
    }
}

