/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.alternator;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.utility.Lang;
import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.content.alternator.DynamoBlock;
import com.teammoeg.steampowered.content.alternator.InternalEnergyStorage;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class DynamoBlockEntity
extends KineticBlockEntity {
    protected final InternalEnergyStorage energy = new InternalEnergyStorage(FE_CAPACITY, 0, MAX_FE_OUT);
    private LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.energy);
    private boolean redstoneLocked = false;
    boolean working;
    public static final int MAX_FE_OUT = (Integer)SPConfig.COMMON.dynamoFeMaxOut.get();
    public static final int FE_CAPACITY = (Integer)SPConfig.COMMON.dynamoFeCapacity.get();
    public static final int IMPACT = (Integer)SPConfig.COMMON.dynamoImpact.get();
    public static final double EFFICIENCY = (Double)SPConfig.COMMON.dynamoEfficiency.get();

    public DynamoBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (((Boolean)this.m_58900_().m_61143_((Property)DynamoBlock.REDSTONE_LOCKED)).booleanValue()) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"tooltip.steampowered.dynamo.locked").m_130940_(ChatFormatting.RED)));
            return true;
        }
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"tooltip.steampowered.energy.production").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237113_((String)(" " + DynamoBlockEntity.format(DynamoBlockEntity.getEnergyProductionRate((int)(this.isSpeedRequirementFulfilled() ? this.getSpeed() : 0.0f))) + "fe/t ")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).style(ChatFormatting.DARK_GRAY).component()));
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    private static String format(int n) {
        if (n > 1000000) {
            return (double)Math.round((double)n / 100000.0) / 10.0 + "M";
        }
        if (n > 1000) {
            return (double)Math.round((double)n / 100.0) / 10.0 + "K";
        }
        return "" + n;
    }

    public float calculateStressApplied() {
        if (((Boolean)this.m_58900_().m_61143_((Property)DynamoBlock.REDSTONE_LOCKED)).booleanValue()) {
            this.lastStressApplied = 0.0f;
            return 0.0f;
        }
        this.lastStressApplied = IMPACT;
        return IMPACT;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side == this.m_58900_().m_61143_((Property)DynamoBlock.FACING)) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
        this.redstoneLocked = compound.m_128471_("redstonelocked");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
        compound.m_128379_("redstonelocked", this.redstoneLocked);
    }

    public void tick() {
        Direction side;
        BlockEntity te;
        super.tick();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)DynamoBlock.REDSTONE_LOCKED)).booleanValue()) {
            if (this.working && this.hasNetwork()) {
                this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
            }
            this.working = false;
            return;
        }
        if (!this.working && this.hasNetwork()) {
            this.getOrCreateNetwork().updateStressFor((KineticBlockEntity)this, this.calculateStressApplied());
        }
        this.working = true;
        if (Math.abs(this.getSpeed()) > 0.0f && this.isSpeedRequirementFulfilled()) {
            this.energy.internalProduceEnergy(DynamoBlockEntity.getEnergyProductionRate((int)this.getSpeed()));
        }
        if ((te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side = (Direction)this.m_58900_().m_61143_((Property)DynamoBlock.FACING)))) != null) {
            te.getCapability(ForgeCapabilities.ENERGY, side.m_122424_()).ifPresent(ies -> ies.receiveEnergy(this.energy.extractEnergy(ies.receiveEnergy(MAX_FE_OUT, true), false), false));
        }
    }

    public static int getEnergyProductionRate(int rpm) {
        rpm = Math.abs(rpm);
        return (int)((double)Math.abs(rpm) * EFFICIENCY);
    }

    public Level getWorld() {
        return this.m_58904_();
    }
}

