/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type.addon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.dimdev.dimdoors.world.pocket.type.addon.ContainedAddon;
import org.dimdev.dimdoors.world.pocket.type.addon.PocketAddon;

public abstract class AddonContainer<T extends ContainedAddon>
implements PocketAddon {
    protected ResourceLocation id;
    protected List<T> addons = new ArrayList<T>();

    public void setId(ResourceLocation id) {
        this.id = id;
    }

    public void addAll(Collection<T> addons) {
        this.addons.addAll(addons);
    }

    public void add(T addon) {
        this.addons.add(addon);
    }

    @Override
    public PocketAddon fromNbt(CompoundTag nbt) {
        this.id = ResourceLocation.m_135820_((String)nbt.m_128461_("id"));
        if (nbt.m_128425_("addons", 9)) {
            for (Tag addonTag : nbt.m_128437_("addons", 10)) {
                this.addons.add((ContainedAddon)PocketAddon.deserialize((CompoundTag)addonTag));
            }
        }
        return this;
    }

    @Override
    public CompoundTag toNbt(CompoundTag nbt) {
        PocketAddon.super.toNbt(nbt);
        ListTag addonsTag = new ListTag();
        for (ContainedAddon addon : this.addons) {
            addonsTag.add((Object)addon.toNbt(new CompoundTag()));
        }
        nbt.m_128365_("addons", (Tag)addonsTag);
        return null;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }
}

