/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world.pocket.type;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.world.pocket.PocketDirectory;
import org.dimdev.dimdoors.world.pocket.type.IdReferencePocket;
import org.dimdev.dimdoors.world.pocket.type.LazyGenerationPocket;
import org.dimdev.dimdoors.world.pocket.type.Pocket;
import org.dimdev.dimdoors.world.pocket.type.PrivatePocket;

public abstract class AbstractPocket<V extends AbstractPocket<?>> {
    public static final Registrar<AbstractPocketType<? extends AbstractPocket<?>>> REGISTRY = RegistrarManager.get((String)"dimdoors").builder(DimensionalDoors.id("abstract_pocket_type"), (Object[])new AbstractPocketType[0]).build();
    protected Integer id;
    protected ResourceKey<Level> world;

    public AbstractPocket(int id, ResourceKey<Level> world) {
        this.id = id;
        this.world = world;
    }

    protected AbstractPocket() {
    }

    public int getId() {
        return this.id;
    }

    public static AbstractPocket<? extends AbstractPocket<?>> deserialize(CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        return ((AbstractPocketType)REGISTRY.get(id)).fromNbt(nbt);
    }

    public static AbstractPocketBuilder<?, ?> deserializeBuilder(CompoundTag nbt) {
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_("type"));
        return ((AbstractPocketType)REGISTRY.get(id)).builder().fromNbt(nbt);
    }

    public static CompoundTag serialize(AbstractPocket<?> pocket) {
        return pocket.toNbt(new CompoundTag());
    }

    public V fromNbt(CompoundTag nbt) {
        this.id = nbt.m_128451_("id");
        this.world = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("world")));
        return (V)this;
    }

    public CompoundTag toNbt(CompoundTag nbt) {
        nbt.m_128405_("id", this.id.intValue());
        nbt.m_128359_("world", this.world.m_135782_().toString());
        this.getType().toNbt(nbt);
        return nbt;
    }

    public abstract AbstractPocketType<?> getType();

    public Map<String, Double> toVariableMap(Map<String, Double> variableMap) {
        variableMap.put("id", (double)this.id);
        return variableMap;
    }

    public abstract Pocket getReferencedPocket();

    public Pocket getReferencedPocket(PocketDirectory directory) {
        return this.getReferencedPocket();
    }

    public ResourceKey<Level> getWorld() {
        return this.world;
    }

    public static interface AbstractPocketType<T extends AbstractPocket<?>> {
        public static final RegistrySupplier<AbstractPocketType<IdReferencePocket>> ID_REFERENCE = AbstractPocketType.register(DimensionalDoors.id(IdReferencePocket.KEY), IdReferencePocket::new, IdReferencePocket::builder);
        public static final RegistrySupplier<AbstractPocketType<Pocket>> POCKET = AbstractPocketType.register(DimensionalDoors.id(Pocket.KEY), Pocket::new, Pocket::builder);
        public static final RegistrySupplier<AbstractPocketType<PrivatePocket>> PRIVATE_POCKET = AbstractPocketType.register(DimensionalDoors.id(PrivatePocket.KEY), PrivatePocket::new, PrivatePocket::builderPrivatePocket);
        public static final RegistrySupplier<AbstractPocketType<LazyGenerationPocket>> LAZY_GENERATION_POCKET = AbstractPocketType.register(DimensionalDoors.id(LazyGenerationPocket.KEY), LazyGenerationPocket::new, LazyGenerationPocket::builderLazyGenerationPocket);

        public T fromNbt(CompoundTag var1);

        public CompoundTag toNbt(CompoundTag var1);

        public T instance();

        public AbstractPocketBuilder<?, T> builder();

        public static void register() {
        }

        public static <U extends AbstractPocket<P>, P extends AbstractPocket<P>> RegistrySupplier<AbstractPocketType<U>> register(final ResourceLocation id, final Supplier<U> supplier, final Supplier<? extends AbstractPocketBuilder<?, U>> factorySupplier) {
            return REGISTRY.register(id, () -> new AbstractPocketType<U>(){

                @Override
                public U fromNbt(CompoundTag nbt) {
                    return ((AbstractPocket)supplier.get()).fromNbt(nbt);
                }

                @Override
                public CompoundTag toNbt(CompoundTag nbt) {
                    nbt.m_128359_("type", id.toString());
                    return nbt;
                }

                @Override
                public U instance() {
                    return (AbstractPocket)supplier.get();
                }

                @Override
                public AbstractPocketBuilder<?, U> builder() {
                    return (AbstractPocketBuilder)factorySupplier.get();
                }
            });
        }
    }

    public static abstract class AbstractPocketBuilder<P extends AbstractPocketBuilder<P, T>, T extends AbstractPocket<?>> {
        protected final AbstractPocketType<T> type;
        private int id;
        private ResourceKey<Level> world;

        protected AbstractPocketBuilder(AbstractPocketType<T> type) {
            this.type = type;
        }

        public Vec3i getExpectedSize() {
            return new Vec3i(1, 1, 1);
        }

        public T build() {
            T instance = this.type.instance();
            ((AbstractPocket)instance).id = this.id;
            ((AbstractPocket)instance).world = this.world;
            return instance;
        }

        public P id(int id) {
            this.id = id;
            return this.getSelf();
        }

        public P world(ResourceKey<Level> world) {
            this.world = world;
            return this.getSelf();
        }

        public P getSelf() {
            return (P)this;
        }

        public abstract P fromNbt(CompoundTag var1);

        public abstract CompoundTag toNbt(CompoundTag var1);
    }
}

