/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.world;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.particle.ModParticleTypes;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.carvers.ModCarvers;
import org.dimdev.dimdoors.world.feature.ModFeatures;

public final class ModBiomes {
    public static final ResourceKey<Biome> PERSONAL_WHITE_VOID_KEY = ModBiomes.register("white_void");
    public static final ResourceKey<Biome> PUBLIC_BLACK_VOID_KEY = ModBiomes.register("black_void");
    public static final ResourceKey<Biome> DUNGEON_DANGEROUS_BLACK_VOID_KEY = ModBiomes.register("dangerous_black_void");
    public static final ResourceKey<Biome> LIMBO_KEY = ModBiomes.register("limbo");

    public static void init() {
    }

    private static ResourceKey<Biome> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)DimensionalDoors.id(name));
    }

    public static void bootstrap(BootstapContext<Biome> entries) {
        entries.m_255272_(LIMBO_KEY, (Object)new Biome.BiomeBuilder().m_47611_(0.0f).m_264558_(false).m_47599_(Biome.TemperatureModifier.NONE).m_47609_(0.8f).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0x404040).m_48034_(0x101010).m_48037_(0).m_48043_(0).m_48040_(0x404040).m_48045_(0x404040).m_48027_(new AmbientMoodSettings((Holder)BuiltInRegistries.f_256894_.m_246971_(ModSoundEvents.CRACK.getKey()), 6000, 8, 2.0)).m_48021_(new Music((Holder)BuiltInRegistries.f_256894_.m_246971_(ModSoundEvents.CREEPY.getKey()), 0, 120000, true)).m_48029_(new AmbientParticleSettings((ParticleOptions)ModParticleTypes.LIMBO_ASH.get(), 0.118093334f)).m_48018_()).m_47601_(new BiomeGenerationSettings.PlainBuilder().m_254863_(GenerationStep.Carving.AIR, (Holder)entries.m_255420_(Registries.f_257003_).m_255043_(ModCarvers.LIMBO)).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, (Holder)entries.m_255420_(Registries.f_256988_).m_255043_(ModFeatures.Placed.SOLID_STATIC_ORE)).m_255380_()).m_47605_(new MobSpawnSettings.Builder().m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.MONOLITH.get(), 100, 1, 10)).m_48381_()).m_47592_());
        Biome.BiomeBuilder voidBiome = new Biome.BiomeBuilder().m_47611_(0.0f).m_47609_(0.8f).m_264558_(false).m_47599_(Biome.TemperatureModifier.NONE).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(0).m_48040_(0).m_48031_(BiomeSpecialEffects.GrassColorModifier.NONE).m_48018_()).m_47605_(MobSpawnSettings.f_48326_).m_47601_(BiomeGenerationSettings.f_47777_);
        entries.m_255272_(PUBLIC_BLACK_VOID_KEY, (Object)voidBiome.m_47592_());
        entries.m_255272_(DUNGEON_DANGEROUS_BLACK_VOID_KEY, (Object)voidBiome.m_47592_());
        entries.m_255272_(PERSONAL_WHITE_VOID_KEY, (Object)new Biome.BiomeBuilder().m_47611_(0.0f).m_47609_(0.8f).m_47599_(Biome.TemperatureModifier.NONE).m_264558_(false).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(0xFFFFFF).m_48040_(0xFFFFFF).m_48031_(BiomeSpecialEffects.GrassColorModifier.NONE).m_48021_(new Music((Holder)BuiltInRegistries.f_256894_.m_246971_(ModSoundEvents.WHITE_VOID.getKey()), 0, 0, true)).m_48018_()).m_47605_(MobSpawnSettings.f_48326_).m_47601_(BiomeGenerationSettings.f_47777_).m_47592_());
    }
}

