/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.pockets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.api.util.Location;
import org.dimdev.dimdoors.api.util.math.MathUtil;
import org.dimdev.dimdoors.block.entity.EntranceRiftBlockEntity;
import org.dimdev.dimdoors.block.entity.RiftBlockEntity;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.entity.MonolithEntity;
import org.dimdev.dimdoors.pockets.DefaultDungeonDestinations;
import org.dimdev.dimdoors.rift.registry.LinkProperties;
import org.dimdev.dimdoors.rift.targets.PocketEntranceMarker;
import org.dimdev.dimdoors.rift.targets.PocketExitMarker;
import org.dimdev.dimdoors.rift.targets.VirtualTarget;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.world.level.registry.DimensionalRegistry;
import org.dimdev.dimdoors.world.pocket.type.Pocket;

public class TemplateUtils {
    static void setupEntityPlaceholders(List<CompoundTag> entities, CompoundTag entityTag) {
        if (entityTag.m_128441_("placeholder")) {
            double x = entityTag.m_128459_("x");
            double y = entityTag.m_128459_("y");
            double z = entityTag.m_128459_("z");
            float yaw = entityTag.m_128457_("yaw");
            float pitch = entityTag.m_128457_("pitch");
            if (!"monolith".equals(entityTag.m_128461_("placeholder"))) {
                throw new RuntimeException("Unknown entity placeholder: " + entityTag.m_128461_("placeholder"));
            }
            MonolithEntity monolith = Objects.requireNonNull((MonolithEntity)((EntityType)ModEntityTypes.MONOLITH.get()).m_20615_(null));
            monolith.m_6034_(x, y, z);
            monolith.m_146922_(yaw);
            monolith.setPitch(pitch);
            CompoundTag newTag = monolith.m_20240_(new CompoundTag());
            entities.add(newTag);
        } else {
            entities.add(entityTag);
        }
    }

    public static void setupLootTable(ServerLevel world, BlockEntity tile, Container inventory, Logger logger) {
        LootTable table;
        if (tile instanceof ChestBlockEntity) {
            logger.debug("Now populating chest.");
            table = world.m_7654_().m_278653_().m_278676_(DimensionalDoors.id("dungeon_chest"));
        } else {
            logger.debug("Now populating dispenser.");
            table = world.m_7654_().m_278653_().m_278676_(DimensionalDoors.id("dispenser_projectiles"));
        }
        LootParams ctx = new LootParams.Builder(world).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82528_((Vec3i)tile.m_58899_())).m_287235_(LootContextParamSets.f_81411_);
        table.m_287188_(inventory, ctx, world.m_7328_());
        if (inventory.m_7983_()) {
            logger.error(", however Inventory is: empty!");
        }
    }

    public static void registerRifts(List<? extends RiftBlockEntity> rifts, VirtualTarget linkTo, LinkProperties linkProperties, Pocket pocket) {
        VirtualTarget dest;
        ServerLevel world = DimensionalDoors.getWorld(pocket.getWorld());
        HashMap<RiftBlockEntity, Float> entranceWeights = new HashMap<RiftBlockEntity, Float>();
        for (RiftBlockEntity riftBlockEntity : rifts) {
            if (!(riftBlockEntity.getDestination() instanceof PocketEntranceMarker)) continue;
            entranceWeights.put(riftBlockEntity, Float.valueOf(((PocketEntranceMarker)riftBlockEntity.getDestination()).getWeight()));
        }
        if (entranceWeights.size() == 0) {
            return;
        }
        RiftBlockEntity selectedEntrance = (RiftBlockEntity)MathUtil.weightedRandom(entranceWeights);
        for (RiftBlockEntity riftBlockEntity : rifts) {
            dest = riftBlockEntity.getDestination();
            if (!(dest instanceof PocketEntranceMarker)) continue;
            if (riftBlockEntity == selectedEntrance) {
                riftBlockEntity.setDestination(((PocketEntranceMarker)dest).getIfDestination());
                riftBlockEntity.register();
                DimensionalRegistry.getRiftRegistry().addPocketEntrance(pocket, new Location((ServerLevel)riftBlockEntity.m_58904_(), riftBlockEntity.m_58899_()));
                continue;
            }
            riftBlockEntity.setDestination(((PocketEntranceMarker)dest).getOtherwiseDestination());
        }
        for (RiftBlockEntity riftBlockEntity : rifts) {
            dest = riftBlockEntity.getDestination();
            if (!(dest instanceof PocketExitMarker)) continue;
            if (linkProperties != null) {
                riftBlockEntity.setProperties(linkProperties);
            }
            riftBlockEntity.setDestination(riftBlockEntity.getProperties() == null || !riftBlockEntity.getProperties().isOneWay() ? linkTo : null);
        }
        for (RiftBlockEntity riftBlockEntity : rifts) {
            riftBlockEntity.register();
            riftBlockEntity.m_6596_();
        }
    }

    public static void replacePlaceholders(Schematic schematic, WorldGenLevel world) {
        ArrayList<CompoundTag> blockEntities = new ArrayList<CompoundTag>();
        for (CompoundTag blockEntityTag : schematic.getBlockEntities()) {
            if (blockEntityTag.m_128441_("placeholder")) {
                int x = blockEntityTag.m_128451_("x");
                int y = blockEntityTag.m_128451_("y");
                int z = blockEntityTag.m_128451_("z");
                BlockPos pos = new BlockPos(x, y, z);
                CompoundTag newTag = new CompoundTag();
                EntranceRiftBlockEntity rift = new EntranceRiftBlockEntity(pos, Schematic.getBlockSample(schematic).m_8055_(pos));
                switch (blockEntityTag.m_128461_("placeholder")) {
                    case "deeper_depth_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getDeeperDungeonDestination());
                        rift.m_183515_(newTag);
                        break;
                    }
                    case "less_deep_depth_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getShallowerDungeonDestination());
                        rift.m_183515_(newTag);
                        break;
                    }
                    case "overworld_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getOverworldDestination());
                        rift.m_183515_(newTag);
                        break;
                    }
                    case "entrance_door": {
                        rift.setProperties(DefaultDungeonDestinations.POCKET_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getTwoWayPocketEntrance());
                        rift.m_183515_(newTag);
                        break;
                    }
                    case "gateway_portal": {
                        rift.setProperties(DefaultDungeonDestinations.OVERWORLD_LINK_PROPERTIES);
                        rift.setDestination(DefaultDungeonDestinations.getGateway());
                        rift.m_183515_(newTag);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown block entity placeholder: " + blockEntityTag.m_128461_("placeholder"));
                    }
                }
                rift.setWorld((Level)world.m_6018_());
                blockEntities.add(newTag);
                continue;
            }
            blockEntities.add(blockEntityTag);
        }
        schematic.setBlockEntities(blockEntities);
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (CompoundTag entityTag : schematic.getEntities()) {
            TemplateUtils.setupEntityPlaceholders(entities, entityTag);
        }
        schematic.setEntities((List<CompoundTag>)entities);
    }
}

