/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.network.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.client.CustomBreakBlockHandler;
import org.dimdev.dimdoors.mixin.client.accessor.WorldRendererAccessor;
import org.dimdev.dimdoors.network.client.ClientPacketListener;
import org.dimdev.dimdoors.network.client.ExtendedClientPlayNetworkHandler;
import org.dimdev.dimdoors.network.packet.s2c.MonolithAggroParticlesPacket;
import org.dimdev.dimdoors.network.packet.s2c.MonolithTeleportParticlesPacket;
import org.dimdev.dimdoors.network.packet.s2c.PlayerInventorySlotUpdateS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.RenderBreakBlockS2CPacket;
import org.dimdev.dimdoors.network.packet.s2c.SyncPocketAddonsS2CPacket;
import org.dimdev.dimdoors.particle.client.MonolithParticle;
import org.dimdev.dimdoors.world.pocket.type.addon.AutoSyncedAddon;

@OnlyIn(value=Dist.CLIENT)
public class ClientPacketHandler
implements ClientPacketListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final net.minecraft.client.multiplayer.ClientPacketListener networkHandler;
    private static final RandomSource clientRandom = RandomSource.m_216327_();
    private ResourceKey<Level> pocketWorld;
    private int gridSize = 1;
    private int pocketId = Integer.MIN_VALUE;
    private int pocketRange = 1;
    private List<AutoSyncedAddon> addons = new ArrayList<AutoSyncedAddon>();

    public static void init() {
        DimensionalDoors.NETWORK.register(PlayerInventorySlotUpdateS2CPacket.class, PlayerInventorySlotUpdateS2CPacket::write, PlayerInventorySlotUpdateS2CPacket::new, PlayerInventorySlotUpdateS2CPacket::apply);
        DimensionalDoors.NETWORK.register(SyncPocketAddonsS2CPacket.class, SyncPocketAddonsS2CPacket::write, SyncPocketAddonsS2CPacket::new, SyncPocketAddonsS2CPacket::apply);
        DimensionalDoors.NETWORK.register(MonolithAggroParticlesPacket.class, MonolithAggroParticlesPacket::write, MonolithAggroParticlesPacket::new, MonolithAggroParticlesPacket::apply);
        DimensionalDoors.NETWORK.register(MonolithTeleportParticlesPacket.class, MonolithTeleportParticlesPacket::write, MonolithTeleportParticlesPacket::new, MonolithTeleportParticlesPacket::apply);
        DimensionalDoors.NETWORK.register(RenderBreakBlockS2CPacket.class, RenderBreakBlockS2CPacket::write, RenderBreakBlockS2CPacket::new, RenderBreakBlockS2CPacket::apply);
    }

    public static <T> boolean sendPacket(T packet) {
        try {
            DimensionalDoors.NETWORK.sendToServer(packet);
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            return false;
        }
    }

    public ClientPacketHandler(net.minecraft.client.multiplayer.ClientPacketListener networkHandler) {
        this.networkHandler = networkHandler;
    }

    public static ClientPacketHandler getHandler() {
        return ((ExtendedClientPlayNetworkHandler)Minecraft.m_91087_().m_91403_()).getDimDoorsPacketHandler();
    }

    public ResourceKey<Level> getPocketWorld() {
        return this.pocketWorld;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getPocketId() {
        return this.pocketId;
    }

    public int getPocketRange() {
        return this.pocketRange;
    }

    public List<AutoSyncedAddon> getAddons() {
        return this.addons;
    }

    @Override
    public void onPlayerInventorySlotUpdate(PlayerInventorySlotUpdateS2CPacket packet) {
        Minecraft.m_91087_().execute(() -> {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_150109_().m_6836_(packet.getSlot(), packet.getStack());
            }
        });
    }

    @Override
    public void onSyncPocketAddons(SyncPocketAddonsS2CPacket packet) {
        this.pocketWorld = packet.getWorld();
        this.gridSize = packet.getGridSize();
        this.pocketId = packet.getPocketId();
        this.pocketRange = packet.getPocketRange();
        this.addons = packet.getAddons();
    }

    @Override
    public void onMonolithAggroParticles(MonolithAggroParticlesPacket packet) {
        Minecraft.m_91087_().execute(() -> ClientPacketHandler.spawnParticles(packet.getAggro()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void spawnParticles(int aggro) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (aggro < 120) {
            return;
        }
        int count = 10 * aggro / 250;
        for (int i = 1; i < count; ++i) {
            player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123760_, player.m_20185_() + (clientRandom.m_188500_() - 0.5) * 3.0, player.m_20186_() + clientRandom.m_188500_() * (double)player.m_20206_() - 0.75, player.m_20189_() + (clientRandom.m_188500_() - 0.5) * (double)player.m_20205_(), (clientRandom.m_188500_() - 0.5) * 2.0, -clientRandom.m_188500_(), (clientRandom.m_188500_() - 0.5) * 2.0);
        }
    }

    @Override
    public void onMonolithTeleportParticles(MonolithTeleportParticlesPacket packet) {
        Minecraft client = Minecraft.m_91087_();
        client.execute(() -> client.f_91061_.m_107344_((Particle)new MonolithParticle(client.f_91073_, client.f_91074_.m_20185_(), client.f_91074_.m_20186_(), client.f_91074_.m_20189_())));
    }

    @Override
    public void onRenderBreakBlock(RenderBreakBlockS2CPacket packet) {
        CustomBreakBlockHandler.customBreakBlock(packet.getPos(), packet.getStage(), ((WorldRendererAccessor)Minecraft.m_91087_().f_91060_).getTicks());
    }
}

