/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.ServerRecipeBook;
import net.minecraft.stats.Stat;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.dimdev.dimdoors.api.util.TeleportUtil;
import org.dimdev.dimdoors.block.UnravelledFabricBlock;
import org.dimdev.dimdoors.criteria.ModCriteria;
import org.dimdev.dimdoors.entity.limbo.LimboEntranceSource;
import org.dimdev.dimdoors.entity.stat.ModStats;
import org.dimdev.dimdoors.mixin.PlayerEntityMixin;
import org.dimdev.dimdoors.world.ModDimensions;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class}, priority=900)
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin {
    @Shadow
    @Final
    private ServerRecipeBook f_8929_;
    private static final float RANDOM_ACTION_CHANCE = 0.1f;
    private static final float CHANCE_TO_MAKE_LIMBO_LIKE_OTHER_DIMENSIONS = 0.1f;
    private static final int CHUNK_SIZES = 25;
    private static final int POSITION_AWAY = 50;
    private static final float RANDOM_LIQUID_CHANCE = 0.7f;
    @Unique
    RandomSource dimdoors_random = RandomSource.m_216327_();

    @Shadow
    public abstract void m_7378_(CompoundTag var1);

    @Shadow
    public abstract void m_6278_(Stat<?> var1, int var2);

    public ServerPlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void playerTickMixin(CallbackInfo ci) {
        if (this.dimdoors_random.m_188501_() <= 0.1f && ModDimensions.isLimboDimension(((Player)this).m_9236_())) {
            this.tryMakingLimboLikeOtherDimensions((Player)this);
        }
    }

    private boolean isValidBlockToReplace(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_7494_()).m_60795_() && world.m_8055_(pos).m_60734_() instanceof UnravelledFabricBlock;
    }

    private void makeLimboLikeOverworld(Player player) {
    }

    private void makeLimboLikeEnd(Player player) {
    }

    private void makeSpotOfLiquid(Level world, BlockPos pos, BlockState state, int range) {
        BlockPos.m_121925_((BlockPos)pos, (int)this.dimdoors_random.m_188503_(range), (int)this.dimdoors_random.m_188503_(range), (int)this.dimdoors_random.m_188503_(range)).forEach(blockPos -> {
            if (this.isValidBlockToReplace(world, (BlockPos)blockPos)) {
                world.m_46597_(blockPos, state);
            }
        });
    }

    private void makeLimboLikeNether(Player player) {
    }

    private void tryMakingLimboLikeOtherDimensions(Player player) {
        if (this.dimdoors_random.m_188501_() > 0.1f) {
            return;
        }
        switch (this.dimdoors_random.m_188503_(3)) {
            case 0: {
                this.makeLimboLikeOverworld(player);
                break;
            }
            case 1: {
                this.makeLimboLikeNether(player);
                break;
            }
            case 2: {
                this.makeLimboLikeEnd(player);
            }
        }
    }

    @Inject(method={"die"}, at={@At(value="HEAD")}, cancellable=true)
    public void checkDeathServer(DamageSource source, CallbackInfo ci) {
        this.doOnDeathStuff(source, ci);
        if (ci.isCancelled()) {
            if (ModDimensions.isPocketDimension(this.m_9236_())) {
                this.m_36220_(ModStats.DEATHS_IN_POCKETS);
            }
            this.m_36220_(ModStats.TIMES_SENT_TO_LIMBO);
            TeleportUtil.teleportRandom(this, (Level)ModDimensions.LIMBO_DIMENSION, 512.0);
            LimboEntranceSource.ofDamageSource(source).broadcast((Player)this, this.m_20194_());
        }
    }

    @Inject(method={"setRespawnPosition"}, at={@At(value="TAIL")})
    public void onSpawnPointSet(ResourceKey<Level> dimension, BlockPos pos, float angle, boolean spawnPointSet, boolean bl, CallbackInfo ci) {
        if (ModDimensions.isPocketDimension(dimension)) {
            ModCriteria.POCKET_SPAWN_POINT_SET.trigger((ServerPlayer)this);
        }
    }
}

