/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.forge;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public class DimensionalDoorsImpl {
    public static Path getConfigRoot() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static void initBuiltinPacks() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DimensionalDoorsImpl::addPackFinders);
    }

    public static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.SERVER_DATA) {
            Pack classicPack = DimensionalDoorsImpl.createPack("classic", "Classic");
            Pack defaultPack = DimensionalDoorsImpl.createPack("default", "Default");
            event.addRepositorySource(packConsumer -> {
                packConsumer.accept(classicPack);
                packConsumer.accept(defaultPack);
            });
        }
    }

    public static Pack createPack(String id, String name) {
        Path resourcePath = ModList.get().getModFileById("dimdoors").getFile().findResource(new String[]{"resourcepacks", id});
        return Pack.m_245429_((String)("builtin/" + id), (Component)Component.m_237113_((String)name), (boolean)false, path -> new PathPackResources(path, resourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10528_);
    }

    public static RecipeBookType createTeselattingRecipeBookType() {
        return RecipeBookType.create((String)"TESSELLATING");
    }
}

