/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.DimensionalDoors;
import org.dimdev.dimdoors.entity.ModEntityTypes;
import org.dimdev.dimdoors.entity.ai.MonolithAggroGoal;
import org.dimdev.dimdoors.item.ModItems;
import org.dimdev.dimdoors.sound.ModSoundEvents;
import org.dimdev.dimdoors.world.ModDimensions;

public class MonolithEntity
extends Mob {
    public static final int MAX_AGGRO = 250;
    private static final int MAX_AGGRO_CAP = 100;
    private static final int MIN_AGGRO_CAP = 25;
    private static final int MAX_TEXTURE_STATE = 18;
    private static final int MAX_SOUND_COOLDOWN = 200;
    public static final int MAX_AGGRO_RANGE = 35;
    private static final EntityDataAccessor<Integer> AGGRO = SynchedEntityData.m_135353_(MonolithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(MonolithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(MonolithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> SOLID = SynchedEntityData.m_135353_(MonolithEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final float EYE_HEIGHT_PERCENTAGE = 0.55f;
    private int soundTime = 0;
    private final int aggroCap;

    MonolithEntity(Level world) {
        this((EntityType<? extends MonolithEntity>)((EntityType)ModEntityTypes.MONOLITH.get()), world);
    }

    public MonolithEntity(EntityType<? extends MonolithEntity> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
        this.aggroCap = Mth.m_216271_((RandomSource)this.m_217043_(), (int)25, (int)100);
        this.m_20242_(true);
        this.f_21365_ = new LookControl(this){

            protected float m_24956_(float from, float to, float maxDelta) {
                return to;
            }

            protected boolean m_8106_() {
                return false;
            }
        };
        this.m_20331_(true);
    }

    public boolean isDangerous() {
        return DimensionalDoors.getConfig().getMonolithsConfig().monolithTeleportation && (ModDimensions.isLimboDimension(this.m_9236_()) || DimensionalDoors.getConfig().getMonolithsConfig().dangerousLimboMonoliths);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_276093_(DamageTypes.f_268612_)) {
            this.setAggro(250);
        }
        return false;
    }

    protected int m_7302_(int i) {
        return 10;
    }

    protected int m_7305_(int i) {
        return 10;
    }

    public boolean m_8023_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(AGGRO, (Object)0);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(PITCH, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(SOLID, (Object)true);
        this.m_6210_();
    }

    public boolean m_6084_() {
        return false;
    }

    public void m_6478_(MoverType moverType, Vec3 vec3) {
    }

    protected void m_8024_() {
        if (!ModDimensions.isLimboDimension(this.m_9236_()) && !ModDimensions.isPocketDimension(this.m_9236_())) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            super.m_8024_();
            return;
        }
        super.m_8024_();
    }

    public void updateAggroLevel(Player player, boolean visibility) {
        if (player == null) {
            return;
        }
        if (((ItemStack)player.m_150109_().f_35975_.get(0)).m_41720_() == ModItems.WORLD_THREAD_HELMET && ((ItemStack)player.m_150109_().f_35975_.get(1)).m_41720_() == ModItems.WORLD_THREAD_CHESTPLATE && ((ItemStack)player.m_150109_().f_35975_.get(2)).m_41720_() == ModItems.WORLD_THREAD_LEGGINGS && ((ItemStack)player.m_150109_().f_35975_.get(3)).m_41720_() == ModItems.WORLD_THREAD_BOOTS) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            if (player.m_20270_((Entity)this) > 70.0f) {
                return;
            }
            int aggro = (Integer)this.f_19804_.m_135370_(AGGRO);
            if (visibility) {
                aggro = ModDimensions.isLimboDimension(this.m_9236_()) ? (this.isDangerous() ? ++aggro : (aggro += 36)) : (aggro += 3);
            } else if (this.isDangerous()) {
                if (aggro > this.aggroCap) {
                    --aggro;
                } else if (aggro < this.aggroCap) {
                    ++aggro;
                }
            } else {
                aggro -= 3;
            }
            int maxAggro = this.isDangerous() ? 250 : 180;
            aggro = (short)Mth.m_14045_((int)aggro, (int)0, (int)maxAggro);
            this.f_19804_.m_135381_(AGGRO, (Object)aggro);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTextureState() {
        return Mth.m_14045_((int)(18 * (Integer)this.f_19804_.m_135370_(AGGRO) / 250), (int)0, (int)18);
    }

    public void playSounds(Vec3 pos) {
        float aggroPercent = this.getAggroProgress();
        float pitch = this.getPitch();
        if (this.soundTime <= 0) {
            this.m_5496_((SoundEvent)ModSoundEvents.MONK.get(), 1.0f, pitch);
            this.soundTime = 100;
        }
        if ((double)aggroPercent > 0.7 && this.soundTime < 100) {
            this.m_9236_().m_5594_(null, new BlockPos(new Vec3i((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_)), (SoundEvent)ModSoundEvents.TEARING.get(), SoundSource.HOSTILE, 1.0f, (float)(1.0 + this.m_217043_().m_188583_()));
            this.soundTime = 100 + this.m_217043_().m_188503_(75);
        }
        if ((double)aggroPercent > 0.8 && this.soundTime < 200) {
            this.m_9236_().m_5594_(null, new BlockPos(new Vec3i((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_)), (SoundEvent)ModSoundEvents.TEARING.get(), SoundSource.HOSTILE, 7.0f, 1.0f);
            this.soundTime = 250;
        }
        --this.soundTime;
    }

    public float m_20236_(Pose pose) {
        return this.m_6972_((Pose)pose).f_20378_ * 0.55f;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return this.m_6972_((Pose)pose).f_20378_ * 0.55f;
    }

    public float getAggroProgress() {
        return (float)this.getAggro() / 250.0f;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new MonolithAggroGoal(this, 35.0f));
    }

    public void facePlayer(Player player) {
        this.f_21365_.m_24960_((Entity)player, 1.0f, 1.0f);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Aggro", this.getAggro());
        nbt.m_128350_("scale", this.m_6134_());
        nbt.m_128350_("pitch", this.getPitch());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setAggro(nbt.m_128451_("Aggro"));
        if (nbt.m_128425_("scale", 5)) {
            this.setScale(nbt.m_128457_("scale"));
        }
        if (nbt.m_128425_("pitch", 5)) {
            this.setPitch(nbt.m_128457_("pitch"));
        }
        if (nbt.m_128425_("solid", 1)) {
            this.setSolid(nbt.m_128471_("solid"));
        }
    }

    private void setSolid(boolean solid) {
        this.f_19804_.m_135381_(SOLID, (Object)solid);
    }

    public boolean getSolid() {
        return (Boolean)this.f_19804_.m_135370_(SOLID);
    }

    public int getAggro() {
        return (Integer)this.f_19804_.m_135370_(AGGRO);
    }

    public void setAggro(int aggro) {
        this.f_19804_.m_135381_(AGGRO, (Object)aggro);
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(scale));
        this.m_6210_();
    }

    public float getPitch() {
        return ((Float)this.f_19804_.m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.f_19804_.m_135381_(PITCH, (Object)Float.valueOf(pitch));
    }

    protected AABB m_20217_(Pose pose) {
        float scale = this.m_6134_();
        return super.m_20217_(pose).m_82377_((double)scale, (double)scale, (double)scale);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (SCALE.equals(data)) {
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        if (spawnReason == MobSpawnType.CHUNK_GENERATION) {
            return super.m_5545_(world, spawnReason);
        }
        if (spawnReason == MobSpawnType.NATURAL) {
            return this.m_217043_().m_188503_(32) == 2;
        }
        return false;
    }
}

