/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.dimdev.dimdoors.util.schematic.Schematic;
import org.dimdev.dimdoors.util.schematic.SchematicPlacer;

public class SchematicStructureTemplate
extends StructureTemplate {
    public SchematicStructureTemplate(CompoundTag tag) {
        this(Schematic.fromNbt(tag));
    }

    public SchematicStructureTemplate(Schematic schematic) {
        this.f_74484_ = new Vec3i((int)schematic.getWidth(), (int)schematic.getHeight(), (int)schematic.getLength());
        this.m_74612_(schematic.getMetadata().author());
        this.f_74482_.clear();
        this.f_74483_.clear();
        this.loadPalette(schematic);
        schematic.getEntities().forEach(compoundTag -> {
            ListTag array = compoundTag.m_128437_("Pos", 6);
            Vec3 vec3 = new Vec3(array.m_128772_(0), array.m_128772_(1), array.m_128772_(2));
            BlockPos pos = new BlockPos((int)vec3.m_7096_(), (int)vec3.m_7098_(), (int)vec3.m_7094_());
            this.f_74483_.add(new StructureTemplate.StructureEntityInfo(vec3, pos, compoundTag));
        });
    }

    private void loadPalette(Schematic schematic) {
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        Map<BlockPos, CompoundTag> blockEntities = schematic.getBlockEntities().stream().collect(Collectors.toMap(compoundTag -> {
            int[] array = compoundTag.m_128465_("Pos");
            return new BlockPos(array[0], array[1], array[2]);
        }, it -> it));
        int[][][] blockData = SchematicPlacer.getBlockData(schematic);
        BiMap palleteList = schematic.getBlockPalette().inverse();
        for (int x = 0; x < schematic.getWidth(); ++x) {
            for (int y = 0; y < schematic.getHeight(); ++y) {
                for (int z = 0; z < schematic.getLength(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    CompoundTag blockEntity = blockEntities.getOrDefault(pos, null);
                    StructureTemplate.StructureBlockInfo info = new StructureTemplate.StructureBlockInfo(pos, (BlockState)palleteList.get((Object)blockData[x][y][z]), blockEntity);
                    SchematicStructureTemplate.m_74573_((StructureTemplate.StructureBlockInfo)info, (List)list, (List)list2, (List)list3);
                }
            }
        }
        List list4 = SchematicStructureTemplate.m_74614_((List)list, (List)list2, (List)list3);
        this.f_74482_.add(new StructureTemplate.Palette(list4));
    }

    public void loadFromSchematic(Schematic schematic) {
        this.f_74482_.clear();
        this.f_74483_.clear();
        this.f_74484_ = new Vec3i((int)schematic.getWidth(), (int)schematic.getHeight(), (int)schematic.getLength());
        StructureTemplate.SimplePalette simplePalette = new StructureTemplate.SimplePalette();
    }

    private void loadPalette(HolderGetter<Block> blockGetter, ListTag paletteTag, ListTag blocksTag) {
        StructureTemplate.SimplePalette simplePalette = new StructureTemplate.SimplePalette();
        for (int i = 0; i < paletteTag.size(); ++i) {
            simplePalette.m_74671_(NbtUtils.m_247651_(blockGetter, (CompoundTag)paletteTag.m_128728_(i)), i);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        for (int j = 0; j < blocksTag.size(); ++j) {
            CompoundTag compoundTag = blocksTag.m_128728_(j);
            ListTag listTag = compoundTag.m_128437_("pos", 3);
            BlockPos blockPos = new BlockPos(listTag.m_128763_(0), listTag.m_128763_(1), listTag.m_128763_(2));
            BlockState blockState = simplePalette.m_74667_(compoundTag.m_128451_("state"));
            CompoundTag compoundTag2 = compoundTag.m_128441_("nbt") ? compoundTag.m_128469_("nbt") : null;
            StructureTemplate.StructureBlockInfo structureBlockInfo = new StructureTemplate.StructureBlockInfo(blockPos, blockState, compoundTag2);
            SchematicStructureTemplate.m_74573_((StructureTemplate.StructureBlockInfo)structureBlockInfo, (List)list, (List)list2, (List)list3);
        }
        List list4 = SchematicStructureTemplate.m_74614_((List)list, (List)list2, (List)list3);
        this.f_74482_.add(new StructureTemplate.Palette(list4));
    }
}

