/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.core.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.dimdev.dimdoors.api.client.Transformer;
import org.joml.Quaternionf;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@OnlyIn(value=Dist.CLIENT)
public enum DefaultTransformation implements Transformer
{
    DOWN{

        @Override
        public void transform(PoseStack matrices) {
        }
    }
    ,
    UP{

        @Override
        public void transform(PoseStack matrices) {
        }
    }
    ,
    NORTH_DOOR{

        @Override
        public void transform(PoseStack matrices) {
            matrices.m_252880_(0.0f, 0.0f, 0.81f);
        }
    }
    ,
    SOUTH_DOOR{

        @Override
        public void transform(PoseStack matrices) {
            matrices.m_252880_(0.0f, 0.0f, 0.19f);
        }
    }
    ,
    WEST_DOOR{

        @Override
        public void transform(PoseStack matrices) {
            matrices.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-90.0)));
            matrices.m_252880_(0.0f, 0.0f, -0.81f);
        }
    }
    ,
    EAST_DOOR{

        @Override
        public void transform(PoseStack matrices) {
            matrices.m_252781_(new Quaternionf().rotateY((float)Math.toRadians(-90.0)));
            matrices.m_252880_(0.0f, 0.0f, -0.19f);
        }
    }
    ,
    NONE{

        @Override
        public void transform(PoseStack matrices) {
        }
    }
    ,
    DIMENSIONAL_PORTAL{

        @Override
        public void transform(PoseStack matrices) {
            matrices.m_252880_(0.0f, 0.0f, 0.5f);
        }
    };

    private static final DefaultTransformation[] VALUES;

    public static DefaultTransformation fromDirection(Direction direction) {
        return VALUES[direction.ordinal()];
    }

    static {
        VALUES = DefaultTransformation.values();
    }
}

