/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.registry;

import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class TFMGTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return TFMGTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return TFMGTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return TFMGTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return TFMGTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        TFMGFluidTags.init();
        TFMGRecipeSerializerTags.init();
    }

    public static enum TFMGFluidTags {
        GAS(NameSpace.MOD),
        FLAMMABLE(NameSpace.MOD),
        GASOLINE(NameSpace.FORGE),
        DIESEL(NameSpace.FORGE),
        KEROSENE(NameSpace.FORGE),
        LPG(NameSpace.FORGE),
        HEAVY_OIL(NameSpace.FORGE),
        LUBRICATION_OIL(NameSpace.FORGE),
        NAPHTHA(NameSpace.FORGE),
        CRUDE_OIL(NameSpace.FORGE),
        MOLTEN_STEEL(NameSpace.FORGE),
        FUEL(NameSpace.FORGE);

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private TFMGFluidTags() {
            this(NameSpace.MOD);
        }

        private TFMGFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private TFMGFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? TFMGTags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum TFMGRecipeSerializerTags {
        AUTOMATION_IGNORE;

        public final TagKey<RecipeSerializer<?>> tag;
        public final boolean alwaysDatagen;

        private TFMGRecipeSerializerTags() {
            this(NameSpace.MOD);
        }

        private TFMGRecipeSerializerTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGRecipeSerializerTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private TFMGRecipeSerializerTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private TFMGRecipeSerializerTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? TFMGTags.optionalTag(ForgeRegistries.RECIPE_SERIALIZERS, id) : TagKey.m_203882_((ResourceKey)Registries.f_256764_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(RecipeSerializer<?> recipeSerializer) {
            return ((Holder)ForgeRegistries.RECIPE_SERIALIZERS.getHolder(recipeSerializer).orElseThrow()).m_203656_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("tfmg", false, true),
        FORGE("forge");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

