/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.machines.firebox;

import com.drmangotea.tfmg.blocks.machines.firebox.FireboxBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FireboxBlock
extends HorizontalDirectionalBlock
implements IBE<FireboxBlockEntity>,
IWrenchable {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> HEAT_LEVEL = BlazeBurnerBlock.HEAT_LEVEL;

    public FireboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT_LEVEL, f_54117_});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos.m_7494_());
        if (!(blockEntity instanceof BasinBlockEntity)) {
            return;
        }
        BasinBlockEntity basin = (BasinBlockEntity)blockEntity;
        basin.notifyChangeOfContents();
    }

    public Class<FireboxBlockEntity> getBlockEntityClass() {
        return FireboxBlockEntity.class;
    }

    public BlockEntityType<? extends FireboxBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.FIREBOX.get();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(HEAT_LEVEL) == BlazeBurnerBlock.HeatLevel.NONE) {
            return null;
        }
        return super.m_142194_(pos, state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        Item item = stack.m_41720_();
        BlockState defaultState = this.m_49966_();
        return (BlockState)defaultState.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level p_180641_2_, BlockPos p_180641_3_) {
        return Math.max(0, ((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).ordinal() - 1);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, Random random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (!((BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SMOULDERING)) {
            return;
        }
        world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
    }

    public static BlazeBurnerBlock.HeatLevel getHeatLevelOf(BlockState blockState) {
        return blockState.m_61138_(HEAT_LEVEL) ? (BlazeBurnerBlock.HeatLevel)blockState.m_61143_(HEAT_LEVEL) : BlazeBurnerBlock.HeatLevel.NONE;
    }

    public static int getLight(BlockState state) {
        BlazeBurnerBlock.HeatLevel level = (BlazeBurnerBlock.HeatLevel)state.m_61143_(HEAT_LEVEL);
        return switch (level) {
            case BlazeBurnerBlock.HeatLevel.NONE, BlazeBurnerBlock.HeatLevel.SMOULDERING -> 0;
            default -> 15;
        };
    }
}

