/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.blocks.electricity.generation.creative_generator;

import com.drmangotea.tfmg.base.MaxBlockVoltage;
import com.drmangotea.tfmg.blocks.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.blocks.electricity.base.cables.VoltagePacket;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class CreativeGeneratorBlockEntity
extends ElectricBlockEntity
implements IHaveGoggleInformation {
    protected ScrollValueBehaviour outputVoltage;
    boolean packetNextTick = false;

    public CreativeGeneratorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.packetNextTick && !this.f_58857_.f_46443_) {
            TFMGPackets.getChannel().send(PacketDistributor.ALL.noArg(), (Object)new VoltagePacket(this.m_58899_()));
            this.packetNextTick = false;
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 250;
        this.outputVoltage = new ScrollValueBehaviour((Component)Lang.translateDirect((String)"creative_generator.voltage_generation", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new CreativeGeneratorValueBox());
        this.outputVoltage.between(0, max);
        this.outputVoltage.value = 50;
        this.outputVoltage.withCallback(i -> this.update());
        behaviours.add((BlockEntityBehaviour)this.outputVoltage);
    }

    public void update() {
        this.needsNetworkUpdate();
        this.needsVoltageUpdate();
        this.packetNextTick = true;
        this.sendStuff();
    }

    @Override
    public int FEProduction() {
        return 1000;
    }

    @Override
    public int FECapacity() {
        return 100000;
    }

    @Override
    public int maxVoltage() {
        return MaxBlockVoltage.MAX_VOLTAGES.get(TFMGBlockEntities.CREATIVE_GENERATOR.get());
    }

    @Override
    public int voltageGeneration() {
        return this.outputVoltage.getValue() * 10;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return true;
    }

    class CreativeGeneratorValueBox
    extends ValueBoxTransform.Sided {
        CreativeGeneratorValueBox() {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)16.0);
        }

        public Vec3 getLocalOffset(BlockState state) {
            return super.getLocalOffset(state);
        }

        public void rotate(BlockState state, PoseStack ms) {
            super.rotate(state, ms);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return direction == Direction.UP;
        }
    }
}

