/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.burner;

import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.content.burner.BurnerBlock;
import com.teammoeg.steampowered.content.burner.IHeatReceiver;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class BurnerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private ItemStackHandler inv = new ItemStackHandler(){

        public boolean isItemValid(int slot, ItemStack stack) {
            return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) != 0 && stack.getCraftingRemainingItem().m_41619_();
        }
    };
    int HURemain;
    private LazyOptional<IItemHandler> holder = LazyOptional.of(() -> this.inv);

    public BurnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.inv.deserializeNBT(nbt.m_128469_("inv"));
        this.HURemain = nbt.m_128451_("hu");
        super.read(nbt, clientPacket);
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("inv", (Tag)this.inv.serializeNBT());
        nbt.m_128405_("hu", this.HURemain);
        super.write(nbt, clientPacket);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.holder.cast() : super.getCapability(cap, side);
    }

    private void refreshCapability() {
        LazyOptional<IItemHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.inv);
        oldCap.invalidate();
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            int emit = this.getHuPerTick();
            while (this.HURemain < emit && this.consumeFuel()) {
            }
            if (this.HURemain < emit) {
                if (this.HURemain > 0) {
                    this.emitHeat(this.HURemain);
                    this.HURemain = 0;
                    this.m_6596_();
                    this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
                }
                if (((Boolean)state.m_61143_((Property)BurnerBlock.LIT)).booleanValue()) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BurnerBlock.LIT, (Comparable)Boolean.valueOf(false)));
                }
            } else {
                this.HURemain -= emit;
                this.emitHeat(emit);
                this.m_6596_();
                if (!((Boolean)state.m_61143_((Property)BurnerBlock.LIT)).booleanValue()) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)BurnerBlock.LIT, (Comparable)Boolean.valueOf(true)));
                } else {
                    this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
                }
            }
        }
    }

    private boolean consumeFuel() {
        if (((Boolean)this.m_58900_().m_61143_((Property)BurnerBlock.REDSTONE_LOCKED)).booleanValue()) {
            return false;
        }
        int time = ForgeHooks.getBurnTime((ItemStack)this.inv.getStackInSlot(0), (RecipeType)RecipeType.f_44108_);
        if (time <= 0) {
            return false;
        }
        this.inv.getStackInSlot(0).m_41774_(1);
        this.HURemain = (int)((double)this.HURemain + (double)(time * (Integer)SPConfig.COMMON.HUPerFuelTick.get()) * this.getEfficiency());
        return true;
    }

    protected void emitHeat(float value) {
        BlockEntity receiver = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (receiver instanceof IHeatReceiver) {
            ((IHeatReceiver)receiver).commitHeat(value);
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Component.m_237110_((String)"tooltip.steampowered.burner.hu", (Object[])new Object[]{this.HURemain}).m_130940_(ChatFormatting.GOLD)));
        if (!this.inv.getStackInSlot(0).m_41619_()) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Component.m_237110_((String)"tooltip.steampowered.burner.item", (Object[])new Object[]{this.inv.getStackInSlot(0).m_41613_(), this.inv.getStackInSlot(0).m_41720_().m_7626_(this.inv.getStackInSlot(0))}).m_130940_(ChatFormatting.GRAY)));
        }
        return true;
    }

    protected abstract int getHuPerTick();

    protected abstract double getEfficiency();
}

