/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.cycle_menu;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.cycle_menu.TagCycleTracker;
import com.railwayteam.railways.registry.CRPalettes;
import com.simibubi.create.foundation.utility.Components;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TagCycleHandlerServer {
    public static final TagCycleTracker CYCLE_TRACKER = new TagCycleTracker();

    private static boolean select(ServerPlayer player, Item target, InteractionHand hand) {
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41720_() == target) {
            return true;
        }
        TagKey<Item> handTag = CYCLE_TRACKER.getCycleTag(handStack.m_41720_());
        TagKey<Item> targetTag = CYCLE_TRACKER.getCycleTag(target);
        if (handTag == null || !handTag.equals(targetTag)) {
            return false;
        }
        ItemStack newStack = new ItemStack((ItemLike)target, handStack.m_41613_());
        newStack.m_41751_(handStack.m_41783_());
        player.m_21008_(hand, newStack);
        return true;
    }

    public static void select(ServerPlayer player, Item target) {
        if (!TagCycleHandlerServer.select(player, target, InteractionHand.MAIN_HAND) && !TagCycleHandlerServer.select(player, target, InteractionHand.OFF_HAND)) {
            Railways.LOGGER.warn("Player {} tried to select {} through tag cycling but failed", (Object)player.m_7755_().getString(), (Object)target.m_41466_().getString());
            player.f_8906_.m_9942_((Component)Components.literal((String)"Invalid tag selection"));
        }
    }

    public static void onTagsUpdated() {
        CYCLE_TRACKER.scheduleRecompute();
    }

    static {
        CRPalettes.CYCLE_GROUPS.values().forEach(CYCLE_TRACKER::registerCycle);
        CYCLE_TRACKER.scheduleRecompute();
    }
}

