/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.world.loot;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MobLootModifier
extends LootModifier {
    private static final Gson LOOT_TABLE_SERIALIZER = Deserializers.m_78800_().create();
    private static final Codec<LootTable> LOOT_TABLE_CODEC = Codec.PASSTHROUGH.flatXmap(dynamic -> {
        try {
            return DataResult.success((Object)ForgeHooks.loadLootTable((Gson)LOOT_TABLE_SERIALIZER, (ResourceLocation)new ResourceLocation("none"), (JsonElement)MobLootModifier.getJson(dynamic), (boolean)true));
        }
        catch (Exception e) {
            LootModifierManager.LOGGER.warn("Unable to decode loot table", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    }, lootTable -> {
        try {
            JsonElement e = LOOT_TABLE_SERIALIZER.toJsonTree(lootTable);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)e));
        }
        catch (Exception e) {
            LootModifierManager.LOGGER.warn("Unable to encode loot table", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    });
    public static final Codec<MobLootModifier> CODEC = RecordCodecBuilder.create(inst -> MobLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)LOOT_TABLE_CODEC.fieldOf("lootTable").forGetter(a -> a.lootTable)).apply((Applicative)inst, MobLootModifier::new));
    private final LootTable lootTable;

    private static <U> JsonElement getJson(Dynamic<?> dynamic) {
        Dynamic<?> typed = dynamic;
        return typed.getValue() instanceof JsonElement ? (JsonElement)typed.getValue() : (JsonElement)typed.getOps().convertTo((DynamicOps)JsonOps.INSTANCE, typed.getValue());
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public MobLootModifier(LootItemCondition[] conditionsIn, LootTable lootTable) {
        super(conditionsIn);
        this.lootTable = lootTable;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        this.lootTable.m_79131_(context, LootTable.m_246283_((ServerLevel)context.m_78952_(), arg_0 -> generatedLoot.add(arg_0)));
        return generatedLoot;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LootTable lootTable;
        private final List<EntityType<?>> entityTypes = new ArrayList();

        public Builder table(LootTable.Builder table) {
            this.lootTable = table.m_79167_();
            return this;
        }

        public Builder onlyFor(EntityType<?> ... types) {
            return this.onlyFor(Arrays.asList(types));
        }

        public Builder onlyFor(List<EntityType<?>> types) {
            this.entityTypes.addAll(types);
            return this;
        }

        public MobLootModifier build() {
            if (this.entityTypes.isEmpty()) {
                throw new IllegalStateException("You must specify target entities");
            }
            return new MobLootModifier(new LootItemCondition[]{this.entityTypes.stream().map(type -> LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(type))).collect(() -> new AnyOfCondition.Builder(new LootItemCondition.Builder[0]), AnyOfCondition.Builder::m_285888_, AnyOfCondition.Builder::m_285888_).m_6409_()}, this.lootTable);
        }
    }
}

