/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModItems;
import de.teamlapen.werewolves.core.ModTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModVillage {
    public static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSIONS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.VILLAGER_PROFESSIONS, (String)"werewolves");
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.POI_TYPES, (String)"werewolves");
    public static final RegistryObject<PoiType> WEREWOLF_FACTION = POI_TYPES.register("werewolf_faction", () -> new PoiType(ModVillage.getAllStates((Block)ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF.get(), (Block)ModBlocks.TOTEM_TOP_WEREWOLVES_WEREWOLF_CRAFTED.get()), 1, 1));
    public static final RegistryObject<VillagerProfession> WEREWOLF_EXPERT = VILLAGER_PROFESSIONS.register("werewolf_expert", () -> new VillagerProfession("werewolf_expert", holder -> holder.m_203656_(ModTags.PoiTypes.IS_WEREWOLF), holder -> holder.m_203656_(ModTags.PoiTypes.IS_WEREWOLF), ImmutableSet.of(), ImmutableSet.of(), null));

    static void register(IEventBus bus) {
        VILLAGER_PROFESSIONS.register(bus);
        POI_TYPES.register(bus);
    }

    public static void villageTradeSetup() {
        VillagerTrades.f_35627_.computeIfAbsent((VillagerProfession)WEREWOLF_EXPERT.get(), trades -> new Int2ObjectOpenHashMap()).putAll(ModVillage.getWerewolfTrades());
    }

    private static Set<BlockState> getAllStates(Block ... blocks) {
        return (Set)Arrays.stream(blocks).map(block -> (BlockState)block.m_49965_().m_61090_()).collect(ImmutableSet.toImmutableSet());
    }

    private static Map<Integer, VillagerTrades.ItemListing[]> getWerewolfTrades() {
        return ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.LIVER.get(), 15, 2, 5, 4), new VillagerTrades.ItemsForEmeralds((Item)ModItems.CRACKED_BONE.get(), 25, 1, 3, 6), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.LIVER.get(), 1, 5, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.CRACKED_BONE.get(), 2, 3, 6)}, (Object)2, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.LIVER.get(), 14, 2, 5, 4), new VillagerTrades.ItemsForEmeralds((Item)ModItems.CRACKED_BONE.get(), 24, 1, 3, 6), new VillagerTrades.ItemsForEmeralds((Item)ModItems.WEREWOLF_TOOTH.get(), 64, 1, 15), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.LIVER.get(), 2, 5, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.CRACKED_BONE.get(), 4, 3, 6)}, (Object)3, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.LIVER.get(), 13, 2, 5, 4), new VillagerTrades.ItemsForEmeralds((Item)ModItems.CRACKED_BONE.get(), 23, 1, 3, 6), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.LIVER.get(), 2, 5, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.CRACKED_BONE.get(), 5, 3, 6)}, (Object)4, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.LIVER.get(), 12, 2, 5, 4), new VillagerTrades.ItemsForEmeralds((Item)ModItems.CRACKED_BONE.get(), 22, 1, 3, 6), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.LIVER.get(), 3, 5, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.CRACKED_BONE.get(), 6, 3, 6)}, (Object)5, (Object)new VillagerTrades.ItemListing[]{new VillagerTrades.ItemsForEmeralds((Item)ModItems.LIVER.get(), 10, 3, 5, 4), new VillagerTrades.ItemsForEmeralds((Item)ModItems.CRACKED_BONE.get(), 20, 2, 3, 6), new VillagerTrades.ItemsForEmeralds((Item)ModItems.WEREWOLF_TOOTH.get(), 35, 1, 15), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.LIVER.get(), 3, 5, 4), new VillagerTrades.EmeraldForItems((ItemLike)ModItems.CRACKED_BONE.get(), 7, 3, 6)});
    }
}

