/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.render;

import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.werewolves.entities.werewolf.HumanWerewolfEntity;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HumanWerewolfRenderer
extends DualBipedRenderer<HumanWerewolfEntity, PlayerModel<HumanWerewolfEntity>> {
    private final Pair<ResourceLocation, Boolean>[] textures = this.gatherTextures("textures/entity/human", true);

    public HumanWerewolfRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), (HumanoidModel)new PlayerModel(context.m_174023_(ModelLayers.f_171166_), true), 0.5f);
    }

    protected Pair<ResourceLocation, Boolean> determineTextureAndModel(HumanWerewolfEntity entity) {
        return this.textures[entity.getSkinType() % this.textures.length];
    }

    protected Pair<ResourceLocation, Boolean> @NotNull [] gatherTextures(@NotNull String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.m_91087_().m_91098_().m_214159_(dirPath, s -> s.m_135815_().endsWith(".png")).keySet());
        Pair[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "werewolves".equals(r.m_135827_())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: werewolves:" + dirPath + "/texture.png");
        }
        return textures;
    }
}

