/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.client.gui;

import de.teamlapen.lib.lib.client.gui.components.ScrollableArrayTextComponentList;
import de.teamlapen.lib.network.IMessage;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import de.teamlapen.werewolves.client.render.WerewolfMinionRenderer;
import de.teamlapen.werewolves.entities.minion.WerewolfMinionEntity;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class WerewolfMinionAppearanceScreen
extends AppearanceScreen<WerewolfMinionEntity> {
    private static final Component NAME = Component.m_237115_((String)"gui.vampirism.minion_appearance");
    private int skinType;
    private int eyeType;
    private boolean glowingEyes;
    private ScrollableArrayTextComponentList skinList;
    private ScrollableArrayTextComponentList eyeList;
    private ExtendedButton skinButton;
    private ExtendedButton eyeButton;
    private Checkbox glowingEyeButton;
    private EditBox nameWidget;

    public WerewolfMinionAppearanceScreen(WerewolfMinionEntity entity, @Nullable Screen backScreen) {
        super(NAME, (LivingEntity)entity, backScreen);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.nameWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + 21, this.guiTop + 29, 98, 12, (Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.name")));
        this.nameWidget.m_94144_(((WerewolfMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.m_94205_(-1);
        this.nameWidget.m_94202_(-1);
        this.nameWidget.m_94199_(15);
        this.nameWidget.m_94151_(this::onNameChanged);
        int skinCount = ((WerewolfMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((WerewolfMinionEntity)this.entity))).getSkinTextureCount(((WerewolfMinionEntity)this.entity).getForm());
        int eyeCount = ((WerewolfMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((WerewolfMinionEntity)this.entity))).getEyeTextureCount(((WerewolfMinionEntity)this.entity).getForm());
        this.eyeType = ((WerewolfMinionEntity)this.entity).getEyeType();
        this.skinType = ((WerewolfMinionEntity)this.entity).getSkinType();
        this.glowingEyes = ((WerewolfMinionEntity)this.entity).hasGlowingEyes();
        this.glowingEyeButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 86, 99, 20, (Component)Component.m_237115_((String)"gui.werewolves.minion_appearance.glowing_eyes"), this.glowingEyes){

            public void m_5691_() {
                super.m_5691_();
                WerewolfMinionAppearanceScreen.this.glowingEyes = this.m_93840_();
                ((WerewolfMinionEntity)WerewolfMinionAppearanceScreen.this.entity).setGlowingEyes(WerewolfMinionAppearanceScreen.this.glowingEyes);
            }
        });
        this.skinList = (ScrollableArrayTextComponentList)this.m_142416_((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80, 20, skinCount, Component.m_237115_((String)"gui.vampirism.minion_appearance.skin"), this::setSkinType, this::previewSkin));
        this.eyeList = (ScrollableArrayTextComponentList)this.m_142416_((GuiEventListener)new ScrollableArrayTextComponentList(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 60, 20, eyeCount, Component.m_237115_((String)"gui.vampirism.appearance.eye"), this::setEyeType, this::previewEye));
        this.skinButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.skinList.m_252754_(), this.skinList.m_252907_() - 20, this.skinList.m_5711_() + 1, 20, (Component)Component.m_237119_(), b -> this.setSkinListVisibility(!this.skinList.f_93624_)));
        this.eyeButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.eyeList.m_252754_(), this.eyeList.m_252907_() - 20, this.eyeList.m_5711_() + 1, 20, (Component)Component.m_237119_(), b -> this.setHatListVisibility(!this.eyeList.f_93624_)));
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.eyeList.m_7979_(mouseX, mouseY, button, dragX, dragY) && !this.skinList.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void m_7861_() {
        Object name = this.nameWidget.m_94155_();
        if (((String)name).isEmpty()) {
            name = Component.m_237115_((String)"text.vampirism.minion").toString() + ((WerewolfMinionEntity)this.entity).getMinionId().orElse(0);
        }
        VampirismMod.dispatcher.sendToServer((IMessage.IServerBoundMessage)new ServerboundAppearancePacket(((WerewolfMinionEntity)this.entity).m_19879_(), (String)name, new int[]{this.skinType, this.eyeType, this.glowingEyes ? 1 : 0}));
        super.m_7861_();
    }

    private void setEyeType(int type) {
        this.eyeType = type;
        ((WerewolfMinionEntity)this.entity).setEyeType(this.eyeType);
        this.setHatListVisibility(false);
    }

    private void setSkinType(int type) {
        this.skinType = type;
        ((WerewolfMinionEntity)this.entity).setSkinType(this.skinType);
        this.setSkinListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((WerewolfMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewEye(int type, boolean hovered) {
        if (hovered) {
            ((WerewolfMinionEntity)this.entity).setEyeType(type);
        } else if (((WerewolfMinionEntity)this.entity).getEyeType() == type) {
            ((WerewolfMinionEntity)this.entity).setEyeType(this.eyeType);
        }
    }

    private void previewSkin(int type, boolean hovered) {
        if (hovered) {
            ((WerewolfMinionEntity)this.entity).setSkinType(type);
        } else if (((WerewolfMinionEntity)this.entity).getSkinType() == type) {
            ((WerewolfMinionEntity)this.entity).setSkinType(this.skinType);
        }
    }

    private void setHatListVisibility(boolean show) {
        this.eyeButton.m_93666_((Component)this.eyeList.m_6035_().m_6881_().m_130946_(" " + (this.eyeType + 1)));
        this.eyeList.f_93624_ = show;
        boolean bl = this.glowingEyeButton.f_93624_ = !show;
        if (show) {
            this.skinList.f_93624_ = false;
        }
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.m_93666_((Component)this.skinList.m_6035_().m_6881_().m_130946_(" " + (this.skinType + 1)));
        this.skinList.f_93624_ = show;
        this.eyeButton.f_93624_ = !show;
        boolean bl = this.glowingEyeButton.f_93624_ = !show;
        if (show) {
            this.eyeList.f_93624_ = false;
        }
    }
}

