/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.werewolves.blocks;

import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.werewolves.WerewolvesMod;
import de.teamlapen.werewolves.blocks.WolfsbaneBlock;
import de.teamlapen.werewolves.blocks.entity.WolfsbaneDiffuserBlockEntity;
import de.teamlapen.werewolves.config.WerewolvesConfig;
import de.teamlapen.werewolves.core.ModBlocks;
import de.teamlapen.werewolves.core.ModTiles;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfsbaneDiffuserBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final VoxelShape shape = WolfsbaneDiffuserBlock.makeShape();
    private final Type type;

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
        VoxelShape b = Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
        return Shapes.m_83110_((VoxelShape)a, (VoxelShape)b);
    }

    public WolfsbaneDiffuserBlock(Type type) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(3.0f).m_60918_(SoundType.f_56742_).m_60955_());
        this.type = type;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        switch (this.type) {
            case LONG: 
            case IMPROVED: {
                pTooltip.add((Component)Component.m_237115_((String)(this.m_7705_() + "." + this.type.m_7912_())).m_130940_(ChatFormatting.AQUA));
            }
        }
        pTooltip.add((Component)Component.m_237115_((String)"block.werewolves.wolfsbane_diffuser.tooltip").m_130940_(ChatFormatting.GRAY));
        int c = VampirismConfig.BALANCE.hsGarlicDiffuserEnhancedDist == null ? 1 : 1 + 2 * this.type.range.get();
        pTooltip.add((Component)Component.m_237110_((String)"block.vampirism.garlic_diffuser.tooltip2", (Object[])new Object[]{c, c}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_6256_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer) {
        WolfsbaneDiffuserBlockEntity tile = this.getTile((BlockGetter)pLevel, pPos);
        if (tile != null) {
            tile.onTouched(pPlayer);
        }
    }

    @NotNull
    public String m_7705_() {
        return "block.werewolves.wolfsbane_diffuser";
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return shape;
    }

    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        WolfsbaneDiffuserBlockEntity tile = new WolfsbaneDiffuserBlockEntity(pPos, pState);
        tile.initiateBootTimer();
        tile.setType(this.type);
        return tile;
    }

    public void m_6240_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pBlockEntity, @NotNull ItemStack pTool) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
        if (pBlockEntity instanceof WolfsbaneDiffuserBlockEntity) {
            WolfsbaneDiffuserBlockEntity wolfbane = (WolfsbaneDiffuserBlockEntity)pBlockEntity;
            wolfbane.onTouched(pPlayer);
        }
    }

    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        WolfsbaneDiffuserBlockEntity t;
        ItemStack heldItem = pPlayer.m_21120_(pHand);
        if (!heldItem.m_41619_() && ((WolfsbaneBlock)((Object)ModBlocks.WOLFSBANE.get())).m_5456_() == heldItem.m_41720_()) {
            WolfsbaneDiffuserBlockEntity t2;
            if (!pLevel.f_46443_ && (t2 = this.getTile((BlockGetter)pLevel, pPos)) != null) {
                if (t2.getFuelTime() > 0) {
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"block.vampirism.garlic_diffuser.already_fueled"), true);
                } else {
                    t2.onFueled();
                    if (!pPlayer.m_7500_()) {
                        heldItem.m_41774_(1);
                    }
                    pPlayer.m_5661_((Component)Component.m_237115_((String)"block.vampirism.garlic_diffuser.successfully_fueled"), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (pLevel.f_46443_ && (t = this.getTile((BlockGetter)pLevel, pPos)) != null) {
            WerewolvesMod.proxy.displayWolfsbaneScreen(t, (Component)this.m_49954_());
        }
        return InteractionResult.SUCCESS;
    }

    private WolfsbaneDiffuserBlockEntity getTile(@NotNull BlockGetter level, @NotNull BlockPos pos) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof WolfsbaneDiffuserBlockEntity) {
            return (WolfsbaneDiffuserBlockEntity)tile;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return WolfsbaneDiffuserBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModTiles.WOLFSBANE_DIFFUSER.get()), WolfsbaneDiffuserBlockEntity::serverTick);
    }

    public static enum Type implements StringRepresentable
    {
        NORMAL("normal", () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserNormalDuration.get() * 20, () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserNormalDist.get(), 1),
        IMPROVED("improved", () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserImprovedDuration.get() * 20, () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserImprovedDist.get(), 2),
        LONG("long", () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserLongDuration.get() * 20, () -> (Integer)WerewolvesConfig.BALANCE.BLOCKS.wolfsbaneDiffuserLongDist.get(), 1);

        private final String name;
        public final Supplier<Integer> fuelTime;
        public final Supplier<Integer> range;
        public final int amplifier;

        private Type(String name, Supplier<Integer> fuelTime, Supplier<Integer> range, int amplifier) {
            this.name = name;
            this.fuelTime = fuelTime;
            this.range = range;
            this.amplifier = amplifier;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

