/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.Arrays;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContextKey;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import net.minecraftforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.NotNull;

public class Permissions {
    public static final PermissionDynamicContextKey<IAction> ACTION_CONTEXT = new PermissionDynamicContextKey(IAction.class, "action", action -> RegUtil.id(action).toString());
    public static final PermissionNode<Boolean> GENERAL_CHECK = new PermissionNode("vampirism", "check", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> true, new PermissionDynamicContextKey[0]);
    public static final Permission FEED = Permissions.create((PermissionNode<Boolean>)new PermissionNode("vampirism", "bite.feed", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> true, new PermissionDynamicContextKey[0]));
    public static final Permission FEED_PLAYER = Permissions.create((PermissionNode<Boolean>)new PermissionNode("vampirism", "bite.feed.player", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> true, new PermissionDynamicContextKey[0]));
    public static final Permission INFECT_PLAYER = Permissions.create((PermissionNode<Boolean>)new PermissionNode("vampirism", "infect.player", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> true, new PermissionDynamicContextKey[0]));
    public static final ContextPermission<IAction> ACTION = new ContextPermission<IAction>((PermissionNode<Boolean>)new PermissionNode("vampirism", "action", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> true, new PermissionDynamicContextKey[0]), ACTION_CONTEXT);

    @SubscribeEvent
    public static void registerNodes(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{GENERAL_CHECK, Permissions.FEED.node, Permissions.FEED_PLAYER.node, Permissions.INFECT_PLAYER.node, ACTION.getNode()});
    }

    public static boolean isPvpEnabled(@NotNull Player player) {
        if (!player.m_20193_().f_46443_) {
            return ServerLifecycleHooks.getCurrentServer().m_129799_();
        }
        return true;
    }

    private static Permission create(PermissionNode<Boolean> node) {
        return new Permission(node);
    }

    public static boolean isSetupCorrectly(ServerPlayer player) {
        return (Boolean)VampirismConfig.SERVER.usePermissions.get() == false || (Boolean)PermissionAPI.getPermission((ServerPlayer)player, GENERAL_CHECK, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false;
    }

    public record Permission(PermissionNode<Boolean> node) {
        public boolean isAllowed(ServerPlayer player) {
            return (Boolean)VampirismConfig.SERVER.usePermissions.get() == false || (Boolean)PermissionAPI.getPermission((ServerPlayer)player, this.node, (PermissionDynamicContext[])new PermissionDynamicContext[0]) != false;
        }

        public boolean isDisallowed(ServerPlayer player) {
            return !this.isAllowed(player);
        }
    }

    public static class ContextPermission<T> {
        private final PermissionNode<Boolean> node;
        private final PermissionDynamicContextKey<T> context;

        public ContextPermission(PermissionNode<Boolean> node, PermissionDynamicContextKey<T> context) {
            this.node = node;
            this.context = context;
        }

        public boolean isAllowed(ServerPlayer player, T context) {
            return (Boolean)VampirismConfig.SERVER.usePermissions.get() == false || (Boolean)PermissionAPI.getPermission((ServerPlayer)player, this.node, (PermissionDynamicContext[])new PermissionDynamicContext[]{this.context.createContext(context)}) != false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SafeVarargs
        public final boolean isAllowed(ServerPlayer player, T ... context) {
            if ((Boolean)VampirismConfig.SERVER.usePermissions.get() == false) return true;
            if ((Boolean)PermissionAPI.getPermission((ServerPlayer)player, this.node, (PermissionDynamicContext[])((PermissionDynamicContext[])Arrays.stream(context).map(arg_0 -> this.context.createContext(arg_0)).toArray(PermissionDynamicContext[]::new))) == false) return false;
            return true;
        }

        public boolean isDisallowed(ServerPlayer player, T context) {
            return !this.isAllowed(player, context);
        }

        @SafeVarargs
        public final boolean isDisallowed(ServerPlayer player, T ... context) {
            return !this.isAllowed(player, context);
        }

        public PermissionNode<Boolean> getNode() {
            return this.node;
        }
    }
}

