/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.tasks.reward;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.core.ModTasks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public class LordLevelReward
implements TaskReward,
ITaskRewardInstance {
    public static final Codec<LordLevelReward> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("targetLevel").forGetter(i -> i.targetLevel), (App)ExtraCodecs.f_252442_.fieldOf("description").forGetter(i -> i.description)).apply((Applicative)inst, LordLevelReward::new));
    public final int targetLevel;
    private final Component description;

    public LordLevelReward(int targetLevel, Component description) {
        this.targetLevel = targetLevel;
        this.description = description;
    }

    public LordLevelReward(int targetLevel) {
        this.targetLevel = targetLevel;
        this.description = Component.m_237110_((String)"task_reward.vampirism.lord_level_reward", (Object[])new Object[]{targetLevel});
    }

    @Override
    public void applyReward(@NotNull IFactionPlayer<?> p) {
        FactionPlayerHandler.getOpt(p.getRepresentingPlayer()).ifPresent(fph -> {
            if (fph.getLordLevel() == this.targetLevel - 1) {
                fph.setLordLevel(this.targetLevel);
            }
        });
    }

    @Override
    @NotNull
    public ITaskRewardInstance createInstance(IFactionPlayer<?> player) {
        return this;
    }

    public Codec<LordLevelReward> codec() {
        return (Codec)ModTasks.LORD_LEVEL_REWARD.get();
    }

    @Override
    public Component description() {
        return this.description;
    }
}

