/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.player.skills;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.entity.player.skills.SkillTree;
import de.teamlapen.vampirism.network.ClientboundSkillTreePacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SkillTreeManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(SkillNode.Builder.class, (json, typeOfT, context) -> {
        JsonObject asObject = GsonHelper.m_13918_((JsonElement)json, (String)"skillnode");
        return SkillNode.Builder.deserialize(asObject, context);
    }).create();
    private static SkillTreeManager instance;
    private final SkillTree skillTree = new SkillTree();

    @NotNull
    public static SkillTreeManager getInstance() {
        if (instance == null) {
            instance = new SkillTreeManager();
        }
        return instance;
    }

    private SkillTreeManager() {
        super(GSON, "vampirismskillnodes");
    }

    @NotNull
    public SkillTree getSkillTree() {
        return this.skillTree;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonObjectMap, @NotNull ResourceManager iResourceManager, @NotNull ProfilerFiller iProfiler) {
        HashMap<ResourceLocation, SkillNode.Builder> parsed = new HashMap<ResourceLocation, SkillNode.Builder>();
        resourceLocationJsonObjectMap.forEach((id, object) -> {
            try {
                SkillNode.Builder builder = (SkillNode.Builder)GSON.fromJson(object, SkillNode.Builder.class);
                if (builder != null) {
                    parsed.put((ResourceLocation)id, builder);
                }
            }
            catch (JsonParseException | IllegalArgumentException e) {
                LOGGER.error("Failed to load skill node {}: {}", id, (Object)e.getMessage());
            }
        });
        this.skillTree.loadNodes(parsed);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            VampirismMod.dispatcher.sendToAll(new ClientboundSkillTreePacket(this.skillTree.getCopy()));
        }
    }
}

