/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minion;

import com.google.common.collect.Lists;
import de.teamlapen.lib.HelperLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.client.gui.screens.VampireMinionAppearanceScreen;
import de.teamlapen.vampirism.client.gui.screens.VampireMinionStatsScreen;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.entity.ai.goals.FleeSunVampireGoal;
import de.teamlapen.vampirism.entity.ai.goals.RestrictSunVampireGoal;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.MinionTasks;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.items.MinionUpgradeItem;
import de.teamlapen.vampirism.items.VampirismItemBloodFoodItem;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.ModDamageSources;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;

public class VampireMinionEntity
extends MinionEntity<VampireMinionData>
implements IVampire {
    private boolean sundamageCache;
    @NotNull
    private EnumStrength garlicCache = EnumStrength.NONE;

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder getAttributeBuilder() {
        return BasicVampireEntity.getAttributeBuilder();
    }

    public VampireMinionEntity(EntityType<? extends VampirismEntity> type, Level world) {
        super(type, world, VampirismAPI.factionRegistry().getPredicate(VReference.VAMPIRE_FACTION, true, true, true, false, null).or(e -> !(e instanceof IFactionEntity) && e instanceof Enemy && !(e instanceof Zombie) && !(e instanceof Skeleton) && !(e instanceof Creeper)));
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining, IDrinkBloodContext drinkContext) {
        @NotNull BloodDrinkEvent.EntityDrinkBloodEvent event = VampirismEventFactory.fireVampireDrinkBlood(this, amt, saturationMod, useRemaining, drinkContext);
        this.m_5634_((float)event.getAmount() / 3.0f);
    }

    @Override
    @NotNull
    public List<IMinionTask<?, ?>> getAvailableTasks() {
        return Lists.newArrayList((Object[])new IMinionTask[]{(IMinionTask)MinionTasks.FOLLOW_LORD.get(), (IMinionTask)MinionTasks.STAY.get(), (IMinionTask)MinionTasks.DEFEND_AREA.get(), (IMinionTask)MinionTasks.COLLECT_BLOOD.get(), (IMinionTask)MinionTasks.PROTECT_LORD.get()});
    }

    @Override
    @NotNull
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    public int getVampireType() {
        return this.getMinionData().map(d -> d.type).map(t -> Math.max(0, t)).orElse(0);
    }

    public boolean hasMinionSpecificSkin() {
        return this.getMinionData().map(d -> d.minionSkin).orElse(false);
    }

    @Override
    @NotNull
    public EnumStrength isGettingGarlicDamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this, iWorld);
        }
        return this.garlicCache;
    }

    @Override
    public void m_8107_() {
        if (this.f_19797_ % 40 == 3) {
            this.isGettingGarlicDamage((LevelAccessor)this.m_9236_(), true);
        }
        if (this.f_19797_ % 8 == 2) {
            this.isGettingSundamage((LevelAccessor)this.m_9236_(), true);
        }
        if (!this.m_9236_().f_46443_) {
            double dmg;
            if (this.isGettingSundamage((LevelAccessor)this.m_9236_()) && this.f_19797_ % 40 == 11 && (dmg = this.m_21051_((Attribute)ModAttributes.SUNDAMAGE.get()).m_22135_()) > 0.0) {
                DamageHandler.hurtModded((Entity)this, ModDamageSources::sunDamage, (float)dmg);
            }
            if (this.isGettingGarlicDamage((LevelAccessor)this.m_9236_()) != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage((LevelAccessor)this.m_9236_()), this.f_19797_);
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_20069_()) {
            this.m_20301_(300);
            if (this.f_19797_ % 16 == 4) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 0));
            }
        }
        super.m_8107_();
    }

    @Override
    @NotNull
    public ItemStack m_5584_(@NotNull Level world, @NotNull ItemStack stack) {
        return stack;
    }

    @Override
    public boolean isGettingSundamage(LevelAccessor iWorld, boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((LivingEntity)this, iWorld, this.m_9236_().m_46473_());
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.m_21023_((MobEffect)ModEffects.SUNSCREEN.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openAppearanceScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new VampireMinionAppearanceScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openStatsScreen() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new VampireMinionStatsScreen(this, Minecraft.m_91087_().f_91080_)));
    }

    public void setUseLordSkin(boolean useLordSkin) {
        this.getMinionData().ifPresent(d -> {
            d.useLordSkin = useLordSkin;
        });
    }

    public void setVampireType(int type, boolean minionSkin) {
        this.getMinionData().ifPresent(d -> {
            d.type = type;
            d.minionSkin = minionSkin;
        });
    }

    @Override
    public boolean shouldRenderLordSkin() {
        return this.getMinionData().map(d -> d.useLordSkin).orElse(false);
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        return false;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected boolean canConsume(@NotNull ItemStack stack) {
        boolean fullHealth;
        if (!super.canConsume(stack)) {
            return false;
        }
        if (stack.m_41614_() && !(stack.m_41720_() instanceof VampirismItemBloodFoodItem)) {
            return false;
        }
        boolean bl = fullHealth = this.m_21223_() == this.m_21233_();
        if (fullHealth && stack.m_41614_() && stack.m_41720_() instanceof VampirismItemBloodFoodItem) {
            return false;
        }
        if (stack.m_41720_() instanceof BloodBottleItem && stack.m_41773_() == 0) {
            return false;
        }
        return !fullHealth || !(stack.m_41720_() instanceof BloodBottleItem);
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack heldItem;
        if (!this.m_9236_().m_5776_() && this.isLord(player) && this.minionData != null && (heldItem = player.m_21120_(hand)).m_41720_() instanceof MinionUpgradeItem && ((MinionUpgradeItem)heldItem.m_41720_()).getFaction() == this.getFaction()) {
            if (((VampireMinionData)this.minionData).level + 1 >= ((MinionUpgradeItem)heldItem.m_41720_()).getMinLevel() && ((VampireMinionData)this.minionData).level + 1 <= ((MinionUpgradeItem)heldItem.m_41720_()).getMaxLevel()) {
                ++((VampireMinionData)this.minionData).level;
                if (!player.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.vampire_minion.binding_upgrade"), false);
                HelperLib.sync(this);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"text.vampirism.vampire_minion.binding_wrong"), false);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void onMinionDataReceived(@NotNull VampireMinionData data) {
        super.onMinionDataReceived(data);
        this.updateAttributes();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, new RestrictSunVampireGoal<VampireMinionEntity>(this));
        this.f_21345_.m_25352_(8, new FleeSunVampireGoal<VampireMinionEntity>(this, 1.0, true));
    }

    public void updateAttributes() {
        float statsMultiplier = this.getMinionData().filter(d -> d.hasIncreasedStats).map(a -> Float.valueOf(1.2f)).orElse(Float.valueOf(1.0f)).floatValue();
        this.m_21051_(Attributes.f_22276_).m_22100_((BalanceMobProps.mobProps.MINION_MAX_HEALTH + (double)BalanceMobProps.mobProps.ADVANCED_VAMPIRE_MAX_FOLLOWER * (double)this.getMinionData().map(VampireMinionData::getHealthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22281_);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        Objects.requireNonNull(BalanceMobProps.mobProps);
        attributeInstance.m_22100_((3.0 + 1.0 * (double)this.getMinionData().map(VampireMinionData::getStrengthLevel).orElse(0).intValue()) * (double)statsMultiplier);
        this.m_21051_(Attributes.f_22279_).m_22100_((BalanceMobProps.mobProps.VAMPIRE_SPEED + 0.05 * (double)this.getMinionData().map(VampireMinionData::getSpeedLevel).orElse(0).intValue()) * (double)statsMultiplier);
    }

    public static class VampireMinionData
    extends MinionData {
        public static final ResourceLocation ID = new ResourceLocation("vampirism", "vampire");
        public static final int MAX_LEVEL = 6;
        public static final int MAX_LEVEL_INVENTORY = 2;
        public static final int MAX_LEVEL_HEALTH = 3;
        public static final int MAX_LEVEL_STRENGTH = 3;
        public static final int MAX_LEVEL_SPEED = 3;
        private int type;
        private boolean useLordSkin;
        private boolean minionSkin;
        private int level;
        private int inventoryLevel;
        private int healthLevel;
        private int strengthLevel;
        private int speedLevel;
        private boolean hasIncreasedStats;

        public VampireMinionData(String name, int type, boolean useLordSkin, boolean hasIncreasedStats) {
            super(name, 9);
            this.type = type;
            this.useLordSkin = useLordSkin;
            this.level = 0;
            this.minionSkin = false;
            this.hasIncreasedStats = hasIncreasedStats;
        }

        public VampireMinionData() {
        }

        @Override
        public void deserializeNBT(@NotNull CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.type = nbt.m_128451_("vampire_type");
            this.level = nbt.m_128451_("level");
            this.useLordSkin = nbt.m_128471_("use_lord_skin");
            this.inventoryLevel = nbt.m_128451_("l_inv");
            this.healthLevel = nbt.m_128451_("l_he");
            this.strengthLevel = nbt.m_128451_("l_str");
            this.speedLevel = nbt.m_128451_("l_spe");
            this.minionSkin = nbt.m_128471_("ms");
            this.hasIncreasedStats = nbt.m_128471_("hasIncreasedStats");
        }

        @Override
        @NotNull
        public MutableComponent getFormattedName() {
            return super.getFormattedName().m_130938_(style -> style.m_131148_(VReference.VAMPIRE_FACTION.getChatColor()));
        }

        public int getHealthLevel() {
            return this.healthLevel;
        }

        public int getInventoryLevel() {
            return this.inventoryLevel;
        }

        @Override
        public int getInventorySize() {
            int size = this.getDefaultInventorySize();
            return this.inventoryLevel == 1 ? size + 3 : (this.inventoryLevel == 2 ? size + 6 : size);
        }

        public int getLevel() {
            return this.level;
        }

        public int getRemainingStatPoints() {
            return Math.max(0, this.level - this.inventoryLevel - this.healthLevel - this.speedLevel - this.strengthLevel);
        }

        public int getSpeedLevel() {
            return this.speedLevel;
        }

        public int getStrengthLevel() {
            return this.strengthLevel;
        }

        @Override
        public void handleMinionAppearanceConfig(String newName, int ... data) {
            this.setName(newName);
            if (data.length >= 2) {
                this.type = data[0];
                this.useLordSkin = (data[1] & 1) == 1;
                this.minionSkin = (data[1] & 2) == 2;
            }
        }

        @Override
        public boolean hasUsedSkillPoints() {
            return this.inventoryLevel + this.healthLevel + this.strengthLevel + this.speedLevel > 0;
        }

        @Override
        public void resetStats(MinionEntity<?> entity) {
            assert (entity instanceof VampireMinionEntity);
            this.inventoryLevel = 0;
            this.healthLevel = 0;
            this.strengthLevel = 0;
            this.speedLevel = 0;
            this.getInventory().setAvailableSize(this.getInventorySize());
            ((VampireMinionEntity)entity).updateAttributes();
            super.resetStats(entity);
        }

        @Override
        public void serializeNBT(@NotNull CompoundTag tag) {
            super.serializeNBT(tag);
            tag.m_128405_("vampire_type", this.type);
            tag.m_128405_("level", this.level);
            tag.m_128379_("use_lord_skin", this.useLordSkin);
            tag.m_128405_("l_inv", this.inventoryLevel);
            tag.m_128405_("l_he", this.healthLevel);
            tag.m_128405_("l_str", this.strengthLevel);
            tag.m_128405_("l_spe", this.speedLevel);
            tag.m_128379_("ms", this.minionSkin);
            tag.m_128379_("hasIncreasedStats", this.hasIncreasedStats);
        }

        public boolean setLevel(int level) {
            if (level < 0 || level > 6) {
                return false;
            }
            boolean levelup = level > this.level;
            this.level = level;
            return levelup;
        }

        @Override
        public boolean upgradeStat(int statId, @NotNull MinionEntity<?> entity) {
            if (super.upgradeStat(statId, entity)) {
                return true;
            }
            if (this.getRemainingStatPoints() == 0) {
                LOGGER.warn("Cannot upgrade minion stat as no stat points are left");
                return false;
            }
            assert (entity instanceof VampireMinionEntity);
            switch (statId) {
                case 0: {
                    if (this.inventoryLevel >= 2) {
                        return false;
                    }
                    ++this.inventoryLevel;
                    this.getInventory().setAvailableSize(this.getInventorySize());
                    return true;
                }
                case 1: {
                    if (this.healthLevel >= 3) {
                        return false;
                    }
                    ++this.healthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 2: {
                    if (this.strengthLevel >= 3) {
                        return false;
                    }
                    ++this.strengthLevel;
                    ((VampireMinionEntity)entity).updateAttributes();
                    return true;
                }
                case 3: {
                    if (this.speedLevel >= 3) {
                        return false;
                    }
                    ++this.speedLevel;
                    return true;
                }
            }
            LOGGER.warn("Cannot upgrade minion stat {} as it does not exist", (Object)statId);
            return false;
        }

        public void setIncreasedStats(boolean hasIncreasedStats) {
            this.hasIncreasedStats = hasIncreasedStats;
        }

        @Override
        protected ResourceLocation getDataType() {
            return ID;
        }
    }
}

