/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.entity.IEntityLeader;
import de.teamlapen.vampirism.blockentity.VulnerableRemainsBlockEntity;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.IRemainsEntity;
import de.teamlapen.vampirism.entity.RemainsDefenderEntity;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VulnerableRemainsDummyEntity
extends LivingEntity
implements IEntityLeader,
IRemainsEntity {
    private BlockPos ownerPos = null;
    private Object2IntMap<Direction> delayRespawn = new Object2IntOpenHashMap();
    private int followerCount = 0;

    public VulnerableRemainsDummyEntity(EntityType<VulnerableRemainsDummyEntity> type, Level pLevel) {
        super(type, pLevel);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_();
    }

    public float m_21223_() {
        return this.getTile().map(VulnerableRemainsBlockEntity::getHealth).orElse(1).intValue();
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    @NotNull
    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public void m_20256_(@NotNull Vec3 pMotion) {
    }

    protected void m_6475_(@NotNull DamageSource pDamageSource, float pDamageAmount) {
        this.getTile().ifPresent(vr -> vr.onDamageDealt(pDamageSource, pDamageAmount));
        Entity entity = pDamageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            attacker.m_6469_(this.m_269291_().m_269374_((Entity)this), 3.0f);
        }
    }

    public void childrenIsHurt(DamageSource damageSource, boolean killed, Direction direction) {
        this.getTile().ifPresent(vr -> vr.onDamageDealt(damageSource, 0.0));
        if (killed) {
            this.delayRespawn.put((Object)direction, 100);
        }
    }

    public boolean m_6673_(@NotNull DamageSource pSource) {
        return this.m_213877_() || pSource.m_269533_(ModTags.DamageTypes.MOTHER_RESISTANT_TO);
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot pSlot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack) {
    }

    public boolean m_6087_() {
        return true;
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    public void m_7334_(@NotNull Entity pEntity) {
    }

    public void setOwnerLocation(BlockPos pos) {
        this.ownerPos = pos;
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        if (!this.m_9236_().f_46443_) {
            BlockState block = this.m_9236_().m_8055_(this.ownerPos);
            if (this.ownerPos == null || !block.m_60713_((Block)ModBlocks.ACTIVE_VULNERABLE_REMAINS.get()) || block.m_60713_((Block)ModBlocks.INCAPACITATED_VULNERABLE_REMAINS.get())) {
                if (block.m_60713_((Block)ModBlocks.INCAPACITATED_VULNERABLE_REMAINS.get())) {
                    this.m_20197_().forEach(s -> s.m_142467_(Entity.RemovalReason.DISCARDED));
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            } else if (this.m_9236_().m_46467_() % 400L == 16L) {
                this.spawnDefender();
            }
        }
    }

    public void spawnDefender() {
        BlockPos pos = this.ownerPos;
        List<Direction> directionStream = Arrays.stream(Direction.values()).filter(direction -> this.delayRespawn.getOrDefault(direction, 0) <= 0).filter(l -> {
            boolean block = this.m_9236_().m_8055_(pos.m_121945_(l)).m_247087_();
            return block && !this.hasDefender((Direction)l);
        }).toList();
        if (!directionStream.isEmpty()) {
            this.spawnDefender(directionStream.get(this.f_19796_.m_188503_(directionStream.size())));
        }
    }

    public void spawnDefenders() {
        this.delayRespawn.clear();
        BlockPos pos = this.ownerPos;
        Arrays.stream(Direction.values()).filter(l -> {
            boolean block = this.m_9236_().m_8055_(pos.m_121945_(l)).m_247087_();
            return block && !this.hasDefender((Direction)l);
        }).forEach(this::spawnDefender);
    }

    private boolean hasDefender(Direction direction) {
        return this.m_20197_().stream().anyMatch(entity -> {
            RemainsDefenderEntity defender;
            return entity instanceof RemainsDefenderEntity && (defender = (RemainsDefenderEntity)entity).getAttachFace().m_122424_() == direction;
        });
    }

    public void spawnDefender(Direction direction) {
        RemainsDefenderEntity defender = (RemainsDefenderEntity)((EntityType)ModEntities.REMAINS_DEFENDER.get()).m_20615_(this.m_9236_());
        this.getTile().map(BlockEntity::m_58899_).ifPresent(pos -> {
            defender.m_146884_(Vec3.m_82539_((Vec3i)pos.m_121945_(direction)));
            defender.setAttachFace(direction.m_122424_());
            this.m_9236_().m_7967_((Entity)defender);
            defender.m_20329_((Entity)this);
            defender.m_146922_(0.0f);
            defender.f_20885_ = this.m_146908_();
            defender.m_146867_();
        });
    }

    protected boolean m_7310_(Entity pPassenger) {
        return pPassenger instanceof RemainsDefenderEntity && this.m_20197_().size() < 6;
    }

    public Optional<VulnerableRemainsBlockEntity> getTile() {
        BlockEntity blockEntity;
        if (this.ownerPos != null && (blockEntity = this.m_9236_().m_7702_(this.ownerPos)) instanceof VulnerableRemainsBlockEntity) {
            VulnerableRemainsBlockEntity vr = (VulnerableRemainsBlockEntity)blockEntity;
            return Optional.of(vr);
        }
        return Optional.empty();
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        pCompound.m_128385_("ownerPos", new int[]{this.ownerPos.m_123341_(), this.ownerPos.m_123342_(), this.ownerPos.m_123343_()});
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        int[] pos = pCompound.m_128465_("ownerPos");
        this.ownerPos = new BlockPos(pos[0], pos[1], pos[2]);
    }

    @Override
    public void decreaseFollowerCount() {
        --this.followerCount;
    }

    @Override
    public int getFollowingCount() {
        return this.followerCount;
    }

    @Override
    public int getMaxFollowerCount() {
        return this.m_6084_() ? Integer.MAX_VALUE : 0;
    }

    @Override
    public LivingEntity getRepresentingEntity() {
        return this;
    }

    @Override
    public boolean increaseFollowerCount() {
        ++this.followerCount;
        return true;
    }

    @Nullable
    public SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.REMAINS_DEATH.get();
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.REMAINS_HURT.get();
    }
}

