/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.mixin.client.HumanoidArmorLayerAccessor;
import de.teamlapen.vampirism.util.TextureComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public abstract class DualBipedRenderer<T extends Mob, M extends HumanoidModel<T>>
extends HumanoidMobRenderer<T, M> {
    @NotNull
    private final M modelA;
    private final M modelB;
    private ResourceLocation currentTexture;

    public DualBipedRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context, @NotNull M modelBipedInA, M modelBipedInB, float shadowSize) {
        super(context, modelBipedInA, shadowSize);
        this.modelA = modelBipedInA;
        this.modelB = modelBipedInB;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return this.currentTexture != null ? this.currentTexture : DefaultPlayerSkin.m_118626_();
    }

    public final void m_7392_(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        Pair<ResourceLocation, Boolean> b = this.determineTextureAndModel(entityIn);
        this.currentTexture = (ResourceLocation)b.getLeft();
        this.f_115290_ = (Boolean)b.getRight() != false ? this.modelB : this.modelA;
        this.renderSelected(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected abstract Pair<ResourceLocation, Boolean> determineTextureAndModel(T var1);

    protected void renderSelected(@NotNull T entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected Pair<ResourceLocation, Boolean> @NotNull [] separateSlimTextures(@NotNull Stream<ResourceLocation> set) {
        return (Pair[])set.map(r -> {
            boolean b = r.m_135815_().endsWith("slim.png");
            return Pair.of((Object)r, (Object)b);
        }).sorted(this.alphaNumericComparator()).toArray(Pair[]::new);
    }

    protected Pair<ResourceLocation, Boolean> @NotNull [] gatherTextures(@NotNull String dirPath, boolean required) {
        ArrayList hunterTextures = new ArrayList(Minecraft.m_91087_().m_91098_().m_214159_(dirPath, s -> s.m_135815_().endsWith(".png")).keySet());
        Pair<ResourceLocation, Boolean>[] textures = this.separateSlimTextures(hunterTextures.stream().filter(r -> "vampirism".equals(r.m_135827_())));
        if (textures.length == 0 && required) {
            throw new IllegalStateException("Must have at least one hunter texture: vampirism:" + dirPath + "/texture.png");
        }
        return textures;
    }

    protected Comparator<Pair<ResourceLocation, Boolean>> alphaNumericComparator() {
        return (o1, o2) -> TextureComparator.alphaNumericComparator().compare((ResourceLocation)o1.getLeft(), (ResourceLocation)o2.getLeft());
    }

    protected static class ArmorLayer<A extends HumanoidModel<T>>
    extends HumanoidArmorLayer<T, M, A> {
        private final A pInnerModel;
        private final A pInnerModelSlim;
        private final A pOuterModel;
        private final A pOuterModelSlim;
        final /* synthetic */ DualBipedRenderer this$0;

        public ArmorLayer(RenderLayerParent<T, M> pRenderer, A pInnerModel, A pInnerModelSlim, A pOuterModel, A pOuterModelSlim, ModelManager pModelManager) {
            this.this$0 = this$0;
            super(pRenderer, pInnerModel, pOuterModel, pModelManager);
            this.pInnerModel = pInnerModel;
            this.pInnerModelSlim = pInnerModelSlim;
            this.pOuterModel = pOuterModel;
            this.pOuterModelSlim = pOuterModelSlim;
        }

        public void render(@NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            Pair<ResourceLocation, Boolean> b = this.this$0.determineTextureAndModel(pLivingEntity);
            A innerModel = (Boolean)b.getRight() != false ? this.pInnerModelSlim : this.pInnerModel;
            A outerModel = (Boolean)b.getRight() != false ? this.pOuterModelSlim : this.pOuterModel;
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.CHEST, pPackedLight, this.getArmorModel(EquipmentSlot.CHEST, innerModel, outerModel));
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.LEGS, pPackedLight, this.getArmorModel(EquipmentSlot.LEGS, innerModel, outerModel));
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.FEET, pPackedLight, this.getArmorModel(EquipmentSlot.FEET, innerModel, outerModel));
            ((HumanoidArmorLayerAccessor)((Object)this)).invoke_renderArmorPiece(pMatrixStack, pBuffer, pLivingEntity, EquipmentSlot.HEAD, pPackedLight, this.getArmorModel(EquipmentSlot.HEAD, innerModel, outerModel));
        }

        private A getArmorModel(EquipmentSlot slot, A innerModel, A outerModel) {
            return ((HumanoidArmorLayerAccessor)((Object)this)).invoke_usesInnerModel(slot) ? innerModel : outerModel;
        }
    }
}

