/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens.skills;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.SkillType;
import de.teamlapen.vampirism.client.gui.screens.skills.SkillsTabScreen;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.items.OblivionItem;
import de.teamlapen.vampirism.network.ServerboundSimpleInputEvent;
import de.teamlapen.vampirism.network.ServerboundUnlockSkillPacket;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NonnullDefault;

@NonnullDefault
public class SkillsScreen
extends Screen {
    public static final int SCREEN_WIDTH = 252;
    public static final int SCREEN_HEIGHT = 219;
    private static final ResourceLocation WINDOW_LOCATION = new ResourceLocation("vampirism", "textures/gui/skills/window.png");
    private static final ResourceLocation TABS_LOCATION = new ResourceLocation("textures/gui/advancements/tabs.png");
    private static final Component VERY_SAD_LABEL = Component.m_237115_((String)"advancements.sad_label");
    private static final Component NO_TABS_LABEL = Component.m_237115_((String)"gui.vampirism.skill_screen.no_tab");
    private static final Component TITLE = Component.m_237115_((String)"gui.vampirism.vampirism_menu.skill_screen");
    @Nullable
    private final IFactionPlayer<?> factionPlayer;
    private final List<SkillsTabScreen> tabs = new ArrayList<SkillsTabScreen>();
    @Nullable
    private final Screen backScreen;
    @Nullable
    private SkillsTabScreen selectedTab;
    @Nullable
    private Button resetSkills;
    private int guiLeft;
    private int guiTop;
    private boolean scrolling;
    @Nullable
    private Vec3 mousePos;
    private boolean clicked;

    public SkillsScreen(@Nullable IFactionPlayer<?> factionPlayer, @Nullable Screen backScreen) {
        super(GameNarrator.f_93310_);
        this.factionPlayer = factionPlayer;
        this.backScreen = backScreen;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        assert (this.f_96541_ != null);
        this.tabs.clear();
        this.guiLeft = (this.f_96543_ - 252) / 2;
        this.guiTop = (this.f_96544_ - 219) / 2;
        if (this.factionPlayer != null) {
            SkillNode rootNode = VampirismMod.proxy.getSkillTree(true).getRootNodeForFaction(this.factionPlayer.getFaction().getID());
            this.tabs.add(new SkillsTabScreen(this.f_96541_, this, 0, new ItemStack((ItemLike)ModItems.VAMPIRE_BOOK.get()), rootNode, this.factionPlayer.getSkillHandler(), (Component)Component.m_237115_((String)"text.vampirism.skills.level")));
            if (this.factionPlayer.getFaction().hasLordSkills() && FactionPlayerHandler.getOpt(this.factionPlayer.getRepresentingPlayer()).map(a -> a.getLordLevel() > 0).orElse(false).booleanValue()) {
                rootNode = VampirismMod.proxy.getSkillTree(true).getRootNodeForFaction(this.factionPlayer.getFaction().getID(), SkillType.LORD);
                this.tabs.add(new SkillsTabScreen(this.f_96541_, this, 1, new ItemStack((ItemLike)ModItems.VAMPIRE_MINION_BINDING.get()), rootNode, this.factionPlayer.getSkillHandler(), (Component)Component.m_237115_((String)"text.vampirism.skills.lord")));
            }
        }
        if (this.tabs.size() > 0) {
            this.selectedTab = this.tabs.get(this.selectedTab == null ? 0 : this.selectedTab.getIndex());
        }
        if (this.backScreen != null) {
            this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 4, this.guiTop + 194, 80, 20, (Component)Component.m_237115_((String)"gui.back"), context -> this.f_96541_.m_91152_(this.backScreen)));
        }
        this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 168, this.guiTop + 194, 80, 20, (Component)Component.m_237115_((String)"gui.done"), context -> this.f_96541_.m_91152_(null)));
        FactionPlayerHandler.getOpt((Player)this.f_96541_.f_91074_).ifPresent(fph -> fph.getCurrentFactionPlayer().ifPresent(factionPlayer -> {
            boolean test = VampirismMod.inDev || REFERENCE.VERSION.isTestVersion();
            this.resetSkills = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.guiLeft + 85, this.guiTop + 194, 80, 20, (Component)Component.m_237115_((String)"text.vampirism.skill.resetall"), context -> {
                VampirismMod.dispatcher.sendToServer(new ServerboundSimpleInputEvent(ServerboundSimpleInputEvent.Type.RESET_SKILLS));
                InventoryHelper.removeItemFromInventory((Container)factionPlayer.getRepresentingPlayer().m_150109_(), new ItemStack((ItemLike)ModItems.OBLIVION_POTION.get()));
                if (!(factionPlayer.getLevel() >= 2 && this.f_96541_.f_91074_.m_150109_().m_18947_((Item)ModItems.OBLIVION_POTION.get()) > 1 || test)) {
                    context.f_93623_ = false;
                }
            }));
            if (!(factionPlayer.getLevel() >= 2 && this.f_96541_.f_91074_.m_150109_().m_18947_((Item)ModItems.OBLIVION_POTION.get()) > 0 || test)) {
                this.resetSkills.f_93623_ = false;
                this.resetSkills.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"text.vampirism.skills.reset_consume", (Object[])new Object[]{((OblivionItem)((Object)((Object)((Object)ModItems.OBLIVION_POTION.get())))).m_41466_()})));
            } else {
                this.resetSkills.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"text.vampirism.skills.reset_req", (Object[])new Object[]{((OblivionItem)((Object)((Object)((Object)ModItems.OBLIVION_POTION.get())))).m_41466_()})));
            }
        }));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.renderInside(graphics, mouseX, mouseY, this.guiLeft, this.guiTop);
        this.renderWindow(graphics, mouseX, mouseY, this.guiLeft, this.guiTop);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY, this.guiLeft, this.guiTop);
    }

    public void renderInside(@NotNull GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        PoseStack pose = graphics.m_280168_();
        if (this.selectedTab != null) {
            this.selectedTab.drawContents(graphics, x + 9, y + 18);
        } else {
            pose.m_85836_();
            pose.m_252880_((float)(x + 9), (float)(y + 18), 0.0f);
            graphics.m_280509_(0, 0, 234, 192, -16777216);
            int i = 117;
            graphics.m_280653_(this.f_96547_, NO_TABS_LABEL, i, 52, -1);
            graphics.m_280653_(this.f_96547_, VERY_SAD_LABEL, i, 104, -1);
            pose.m_85849_();
        }
    }

    public void renderWindow(@NotNull GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.m_280218_(WINDOW_LOCATION, x, y, 0, 0, 252, 219);
        if (this.tabs.size() > 1) {
            for (SkillsTabScreen skillTab : this.tabs) {
                skillTab.drawTab(graphics, x, y, skillTab == this.selectedTab);
            }
            for (SkillsTabScreen skillTab : this.tabs) {
                skillTab.drawIcon(graphics, x, y);
            }
        }
        if (this.selectedTab != null) {
            int remaining = this.selectedTab.getRemainingPoints();
            MutableComponent remainingPoints = Component.m_237110_((String)"text.vampirism.skills.points_left", (Object[])new Object[]{remaining == Integer.MAX_VALUE ? "\u221e" : String.valueOf(remaining)});
            graphics.m_280614_(this.f_96547_, (Component)remainingPoints, x + 240 - this.f_96547_.m_92852_((FormattedText)remainingPoints), y + 6, 0x404040, false);
        }
        graphics.m_280614_(this.f_96547_, TITLE, x + 8, y + 6, 0x404040, false);
    }

    public void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY, int guiLeft, int guiTop) {
        if (this.f_96541_.f_91074_.m_21124_((MobEffect)ModEffects.OBLIVION.get()) != null) {
            return;
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.selectedTab != null) {
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            pose.m_252880_((float)(guiLeft + 9), (float)(guiTop + 18), 400.0f);
            this.selectedTab.drawTooltips(graphics, mouseX - guiLeft - 9, mouseY - guiTop - 18);
            pose.m_85849_();
        }
        if (this.tabs.size() > 1) {
            for (SkillsTabScreen tabScreen : this.tabs) {
                if (!tabScreen.isMouseOver(guiLeft, guiTop, mouseX, mouseY)) continue;
                graphics.m_280557_(this.f_96541_.f_91062_, tabScreen.getTitle(), mouseX, mouseY);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.scrolling) {
            this.scrolling = false;
        }
        if (button == 0) {
            this.clicked = true;
            this.mousePos = new Vec3(mouseX, mouseY, 0.0);
            for (SkillsTabScreen tab : this.tabs) {
                if (tab == this.selectedTab || !tab.isMouseOver(this.guiLeft, this.guiTop, mouseX, mouseY)) continue;
                this.selectedTab = tab;
                break;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.selectedTab != null && this.f_96541_.f_91074_.m_21124_((MobEffect)ModEffects.OBLIVION.get()) == null) {
            return this.selectedTab.mouseScrolled(mouseX, mouseY, amount);
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        block2: {
            block3: {
                block4: {
                    if (button != 0) break block2;
                    if (!this.clicked) break block3;
                    if (!this.scrolling) break block4;
                    if (this.mousePos == null) break block3;
                    Vec3 vec3 = new Vec3(mouseX, mouseY, 0.0);
                    if (!(this.mousePos.m_82554_(vec3) < 5.0)) break block3;
                }
                this.unlockSkill(mouseX, mouseY);
            }
            this.clicked = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double xDragged, double yDragged) {
        this.scrolling = true;
        if (this.selectedTab != null && this.f_96541_.f_91074_.m_21124_((MobEffect)ModEffects.OBLIVION.get()) == null) {
            this.selectedTab.mouseDragged(mouseX, mouseY, mouseButton, xDragged, yDragged);
        }
        return super.m_7979_(mouseX, mouseY, mouseButton, xDragged, yDragged);
    }

    private void unlockSkill(double mouseX, double mouseY) {
        ISkill<?> selected;
        ISkill<?> iSkill = selected = this.selectedTab != null ? this.selectedTab.getSelected((int)(mouseX - (double)this.guiLeft - 9.0), (int)(mouseY - (double)this.guiTop - 18.0)) : null;
        if (selected != null) {
            if (this.canUnlockSkill(selected)) {
                VampirismMod.dispatcher.sendToServer(new ServerboundUnlockSkillPacket(RegUtil.id(selected)));
                this.playSoundEffect(SoundEvents.f_12275_, 0.7f);
            } else {
                this.playSoundEffect((SoundEvent)SoundEvents.f_12209_.get(), 0.5f);
            }
        }
    }

    private boolean canUnlockSkill(@NotNull ISkill skill) {
        if (this.factionPlayer == null) {
            return false;
        }
        return this.factionPlayer.getSkillHandler().canSkillBeEnabled(skill) == ISkillHandler.Result.OK;
    }

    private void playSoundEffect(@NotNull SoundEvent event, float pitch) {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)event, (float)1.0f));
    }
}

