/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blockentity.VampireBeaconBlockEntity;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.inventory.VampireBeaconMenu;
import de.teamlapen.vampirism.network.ServerboundSetVampireBeaconPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampireBeaconScreen
extends AbstractContainerScreen<VampireBeaconMenu> {
    private static final ResourceLocation BEACON_LOCATION = new ResourceLocation("vampirism", "textures/gui/container/vampire_beacon.png");
    private static final Component EFFECT_LABEL = Component.m_237115_((String)"container.vampirism.vampire_beacon.power");
    private final List<BeaconButton> beaconButtons = new ArrayList<BeaconButton>();
    @Nullable
    private MobEffect primary;
    private int amplifier;
    private boolean isUpgraded;

    public VampireBeaconScreen(VampireBeaconMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 230;
        this.f_97727_ = 219;
        pMenu.m_38893_(new ContainerListener(){

            public void m_7934_(@NotNull AbstractContainerMenu pContainerToSend, int pDataSlotIndex, @NotNull ItemStack pStack) {
            }

            public void m_142153_(@NotNull AbstractContainerMenu pContainerMenu, int pDataSlotIndex, int pValue) {
                VampireBeaconScreen.this.primary = ((VampireBeaconMenu)VampireBeaconScreen.this.f_97732_).getPrimaryEffect();
                VampireBeaconScreen.this.amplifier = ((VampireBeaconMenu)VampireBeaconScreen.this.f_97732_).getAmplifier();
                VampireBeaconScreen.this.isUpgraded = ((VampireBeaconMenu)VampireBeaconScreen.this.f_97732_).isUpgraded();
                VampireBeaconScreen.this.m_6702_().forEach(pWidget -> {
                    if (pWidget instanceof BeaconPowerButton) {
                        BeaconPowerButton button = (BeaconPowerButton)pWidget;
                        button.m_257936_();
                    }
                });
            }
        });
    }

    private <T extends AbstractWidget> void addBeaconButton(T button) {
        this.m_142416_((GuiEventListener)button);
        this.beaconButtons.add((BeaconButton)button);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.beaconButtons.clear();
        this.addBeaconButton(new BeaconConfirmButton(this.f_97735_ + 164, this.f_97736_ + 107));
        this.addBeaconButton(new BeaconCancelButton(this.f_97735_ + 190, this.f_97736_ + 107));
        for (int i = 0; i <= 2; ++i) {
            int j = VampireBeaconBlockEntity.BEACON_EFFECTS[i].length;
            int k = j * 22 + (j - 1) * 2;
            for (int l = 0; l < j; ++l) {
                MobEffect mobeffect = VampireBeaconBlockEntity.BEACON_EFFECTS[i][l];
                int amplifier = VampireBeaconBlockEntity.BEACON_EFFECTS_AMPLIFIER[i][l];
                BeaconPowerButton beaconscreen$beaconpowerbutton = new BeaconPowerButton(this.f_97735_ + 76 + 62 + l * 24 - k / 2, this.f_97736_ + 22 + i * 25, mobeffect, amplifier, i);
                beaconscreen$beaconpowerbutton.f_93623_ = false;
                this.addBeaconButton(beaconscreen$beaconpowerbutton);
            }
        }
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateButtons();
    }

    void updateButtons() {
        int i = ((VampireBeaconMenu)this.f_97732_).getLevels();
        this.beaconButtons.forEach(p_169615_ -> p_169615_.updateStatus(i));
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280653_(this.f_96547_, EFFECT_LABEL, 117, 10, 0xE0E0E0);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(BEACON_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        pGuiGraphics.m_280480_(new ItemStack((ItemLike)ModItems.PURE_BLOOD_0.get()), i + 41, j + 109);
        pGuiGraphics.m_280480_(new ItemStack((ItemLike)ModItems.SOUL_ORB_VAMPIRE.get()), i + 41 + 22, j + 109);
        pGuiGraphics.m_280480_(new ItemStack((ItemLike)ModItems.HUMAN_HEART.get()), i + 42 + 44, j + 109);
        pGuiGraphics.m_280480_(new ItemStack((ItemLike)ModItems.WEAK_HUMAN_HEART.get()), i + 42 + 66, j + 109);
        pGuiGraphics.m_280168_().m_85849_();
    }

    public void m_88315_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    static interface BeaconButton {
        public void updateStatus(int var1);
    }

    @OnlyIn(value=Dist.CLIENT)
    class BeaconConfirmButton
    extends BeaconSpriteScreenButton {
        public BeaconConfirmButton(int pX, int pY) {
            super(pX, pY, 90, 220, CommonComponents.f_130655_);
        }

        public void m_5691_() {
            VampirismMod.dispatcher.sendToServer(new ServerboundSetVampireBeaconPacket(Optional.ofNullable(VampireBeaconScreen.this.primary), Optional.of(VampireBeaconScreen.this.amplifier)));
            ((VampireBeaconScreen)VampireBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int pBeaconTier) {
            this.f_93623_ = ((VampireBeaconMenu)VampireBeaconScreen.this.f_97732_).hasPayment() && VampireBeaconScreen.this.primary != null;
        }
    }

    class BeaconCancelButton
    extends BeaconSpriteScreenButton {
        public BeaconCancelButton(int pX, int pY) {
            super(pX, pY, 112, 220, CommonComponents.f_130656_);
        }

        public void m_5691_() {
            ((VampireBeaconScreen)VampireBeaconScreen.this).f_96541_.f_91074_.m_6915_();
        }

        @Override
        public void updateStatus(int pBeaconTier) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class BeaconPowerButton
    extends BeaconScreenButton {
        protected final int tier;
        private MobEffect effect;
        private int effectAmplifier;
        private TextureAtlasSprite sprite;

        public BeaconPowerButton(int pX, int pY, MobEffect pEffect, int effectAmplifier, int pTier) {
            super(pX, pY);
            this.effectAmplifier = effectAmplifier;
            this.tier = pTier;
            this.setEffect(pEffect, effectAmplifier);
        }

        protected void setEffect(MobEffect pEffect, int effectAmplifier) {
            this.effect = pEffect;
            this.effectAmplifier = effectAmplifier;
            this.sprite = Minecraft.m_91087_().m_91306_().m_118732_(pEffect);
            this.m_257936_();
        }

        public void m_257936_() {
            this.m_257544_(Tooltip.m_257563_((Component)this.createEffectDescription(this.effect, this.effectAmplifier), null));
        }

        protected MutableComponent createEffectDescription(MobEffect pEffect, int amplifier) {
            MutableComponent component = Component.m_237115_((String)pEffect.m_19481_());
            if (!VampireBeaconBlockEntity.NO_AMPLIFIER_EFFECTS.contains(pEffect)) {
                amplifier += ((VampireBeaconMenu)VampireBeaconScreen.this.f_97732_).isUpgraded() ? 1 : 0;
            }
            if (amplifier <= 0) {
                return component;
            }
            return Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{component, Component.m_237115_((String)("potion.potency." + amplifier))});
        }

        public void m_5691_() {
            if (!this.isSelected()) {
                VampireBeaconScreen.this.primary = this.effect;
                VampireBeaconScreen.this.amplifier = this.effectAmplifier;
                VampireBeaconScreen.this.updateButtons();
            }
        }

        @Override
        protected void renderIcon(GuiGraphics pGuiGraphics) {
            pGuiGraphics.m_280159_(this.m_252754_() + 2, this.m_252907_() + 2, 0, 18, 18, this.sprite);
        }

        @Override
        public void updateStatus(int pBeaconTier) {
            this.f_93623_ = this.tier < pBeaconTier;
            this.setSelected(this.effect == VampireBeaconScreen.this.primary);
        }

        @NotNull
        protected MutableComponent m_5646_() {
            return this.createEffectDescription(this.effect, this.effectAmplifier);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class BeaconSpriteScreenButton
    extends BeaconScreenButton {
        private final int iconX;
        private final int iconY;

        protected BeaconSpriteScreenButton(int p_169663_, int p_169664_, int p_169665_, int p_169666_, Component p_169667_) {
            super(p_169663_, p_169664_, p_169667_);
            this.iconX = p_169665_;
            this.iconY = p_169666_;
        }

        @Override
        protected void renderIcon(GuiGraphics p_283624_) {
            p_283624_.m_280218_(BEACON_LOCATION, this.m_252754_() + 2, this.m_252907_() + 2, this.iconX, this.iconY, 18, 18);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static abstract class BeaconScreenButton
    extends AbstractButton
    implements BeaconButton {
        private boolean selected;

        protected BeaconScreenButton(int pX, int pY) {
            super(pX, pY, 22, 22, CommonComponents.f_237098_);
        }

        protected BeaconScreenButton(int pX, int pY, Component pMessage) {
            super(pX, pY, 22, 22, pMessage);
        }

        public void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            int i = 219;
            int j = 0;
            if (!this.f_93623_) {
                j += this.f_93618_ * 2;
            } else if (this.selected) {
                j += this.f_93618_;
            } else if (this.m_198029_()) {
                j += this.f_93618_ * 3;
            }
            pGuiGraphics.m_280218_(BEACON_LOCATION, this.m_252754_(), this.m_252907_(), j, 219, this.f_93618_, this.f_93619_);
            this.renderIcon(pGuiGraphics);
        }

        protected abstract void renderIcon(GuiGraphics var1);

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean pSelected) {
            this.selected = pSelected;
        }

        public void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
            this.m_168802_(pNarrationElementOutput);
        }
    }
}

