/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VampirismSplitBlock
extends VampirismBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    private final VoxelShape NORTH1;
    @NotNull
    private final VoxelShape EAST1;
    @NotNull
    private final VoxelShape SOUTH1;
    @NotNull
    private final VoxelShape WEST1;
    private final VoxelShape NORTH2;
    @NotNull
    private final VoxelShape EAST2;
    @NotNull
    private final VoxelShape SOUTH2;
    @NotNull
    private final VoxelShape WEST2;
    private final boolean vertical;

    public VampirismSplitBlock(@NotNull BlockBehaviour.Properties properties, VoxelShape mainShape, VoxelShape subShape, boolean vertical) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.MAIN)));
        this.NORTH1 = mainShape;
        this.EAST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.NINETY);
        this.SOUTH1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST1 = UtilLib.rotateShape(this.NORTH1, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.NORTH2 = subShape;
        this.EAST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.NINETY);
        this.SOUTH2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.HUNDRED_EIGHTY);
        this.WEST2 = UtilLib.rotateShape(this.NORTH2, UtilLib.RotationAmount.TWO_HUNDRED_SEVENTY);
        this.vertical = vertical;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState p_149645_1_) {
        return p_149645_1_.m_61143_(PART) == Part.MAIN ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        boolean main = state.m_61143_(PART) == Part.MAIN;
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> {
                if (main) {
                    yield this.NORTH1;
                }
                yield this.NORTH2;
            }
            case Direction.EAST -> {
                if (main) {
                    yield this.EAST1;
                }
                yield this.EAST2;
            }
            case Direction.SOUTH -> {
                if (main) {
                    yield this.SOUTH1;
                }
                yield this.SOUTH2;
            }
            case Direction.WEST -> {
                if (main) {
                    yield this.WEST1;
                }
                yield this.WEST2;
            }
            default -> this.NORTH1;
        };
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        Direction enumfacing = context.m_8125_();
        BlockPos blockpos = context.m_8083_();
        BlockPos blockpos1 = blockpos.m_121945_(this.vertical ? Direction.UP : enumfacing);
        return context.m_43725_().m_8055_(blockpos1).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)enumfacing) : null;
    }

    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return false;
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, @NotNull Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5707_(@NotNull Level world, @NotNull BlockPos blockPos, @NotNull BlockState blockState, @NotNull Player player) {
        BlockPos blockpos;
        BlockState otherState;
        Part part;
        if (!world.f_46443_ && player.m_7500_() && (part = (Part)((Object)blockState.m_61143_(PART))) == Part.SUB && (otherState = world.m_8055_(blockpos = blockPos.m_121945_(this.getOtherBlockDirection(blockState)))).m_60734_() == this && otherState.m_61143_(PART) == Part.MAIN) {
            world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)otherState));
        }
        super.m_5707_(world, blockPos, blockState, player);
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, @NotNull Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            BlockPos blockpos = pos.m_121945_(this.getOtherBlockDirection(state));
            BlockState otherState = (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.SUB));
            if (!this.vertical) {
                otherState = (BlockState)otherState.m_61124_((Property)FACING, (Comparable)((Direction)otherState.m_61143_((Property)FACING)).m_122424_());
            }
            world.m_7731_(blockpos, otherState, 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == this.getOtherBlockDirection(stateIn)) {
            return facingState.m_60734_() == this && facingState.m_61143_(PART) != stateIn.m_61143_(PART) ? this.updateFromOther(stateIn, facingState) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, PART});
    }

    @NotNull
    protected Direction getOtherBlockDirection(@NotNull BlockState blockState) {
        if (this.vertical) {
            return blockState.m_61143_(PART) == Part.MAIN ? Direction.UP : Direction.DOWN;
        }
        return (Direction)blockState.m_61143_((Property)FACING);
    }

    protected BlockState updateFromOther(BlockState thisState, BlockState otherState) {
        return thisState;
    }

    public static enum Part implements StringRepresentable
    {
        MAIN("main"),
        SUB("sub");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

