/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.actions;

import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.effect.EffectInstanceWithSource;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DefaultAction<T extends IFactionPlayer<T>>
implements IAction<T> {
    private Component name;

    public void addEffectInstance(@NotNull T player, @NotNull MobEffectInstance instance) {
        ((EffectInstanceWithSource)instance).setSource(this.getRegistryName());
        player.getRepresentingPlayer().m_7292_(instance);
    }

    public boolean canBeUsedBy(T player) {
        return true;
    }

    @Override
    public final @NotNull IAction.PERM canUse(@NotNull T player) {
        if (!this.isEnabled()) {
            return IAction.PERM.DISABLED;
        }
        if (this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            return this.canBeUsedBy(player) ? IAction.PERM.ALLOWED : IAction.PERM.DISALLOWED;
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().get().getFactionPlayerInterface());
    }

    @Override
    @NotNull
    public Component getName() {
        return this.name == null ? (this.name = Component.m_237115_((String)this.getTranslationKey())) : this.name;
    }

    @Override
    @Deprecated
    @NotNull
    public String getTranslationKey() {
        return "action." + this.getRegistryName().m_135827_() + "." + this.getRegistryName().m_135815_();
    }

    public abstract boolean isEnabled();

    @Override
    public boolean onActivated(@NotNull T player, IAction.ActivationContext context) {
        if (this.getFaction().map(f -> f.getFactionPlayerInterface().isInstance(player)).orElse(true).booleanValue()) {
            return this.activate(player, context);
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().get().getFactionPlayerInterface());
    }

    public void removePotionEffect(@NotNull T player, @NotNull MobEffect effect) {
        MobEffectInstance ins = player.getRepresentingPlayer().m_21124_(effect);
        while (ins != null) {
            EffectInstanceWithSource insM = (EffectInstanceWithSource)ins;
            if (insM.hasSource() && insM.getSource().equals((Object)this.getRegistryName())) {
                insM.removeEffect();
                break;
            }
            ins = insM.getHiddenEffect();
        }
    }

    @NotNull
    public String toString() {
        return this.getRegistryName() + " (" + this.getClass().getSimpleName() + ")";
    }

    protected abstract boolean activate(T var1, IAction.ActivationContext var2);

    @Nullable
    private ResourceLocation getRegistryName() {
        return VampirismRegistries.ACTIONS.get().getKey((Object)this);
    }
}

