/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.content.buffer.BufferBlockPlaceContext;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackBufferBlockItem
extends TrackTargetingBlockItem {
    public static <T extends Block> NonNullBiFunction<? super T, Item.Properties, TrackTargetingBlockItem> ofType(EdgePointType<?> type) {
        return (b, p) -> new TrackBufferBlockItem((Block)b, (Item.Properties)p, type);
    }

    public TrackBufferBlockItem(Block pBlock, Item.Properties pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties, type);
    }

    @Nullable
    protected BlockState m_5965_(@NotNull BlockPlaceContext context) {
        if (context instanceof BufferBlockPlaceContext) {
            BufferBlockPlaceContext bufferContext = (BufferBlockPlaceContext)context;
            if (bufferContext.overrideBlock != null) {
                BlockState blockState = bufferContext.overrideBlock.m_5573_(context);
                return blockState != null && this.m_40610_(context, blockState) ? blockState : null;
            }
        }
        return super.m_5965_(context);
    }

    private static boolean isOkShape(BlockState state) {
        TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
        return switch (shape) {
            case TrackShape.ZO, TrackShape.XO, TrackShape.PD, TrackShape.ND, TrackShape.TE, TrackShape.TN, TrackShape.TS, TrackShape.TW -> true;
            default -> false;
        };
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(pos);
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Block block = state.m_60734_();
        if (block instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)block;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Vec3 lookAngle = player.m_20154_();
            Pair nearestTrackAxis = track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle);
            boolean front = nearestTrackAxis.getSecond() == Direction.AxisDirection.NEGATIVE;
            Vec3 biasedDirection = ((Vec3)nearestTrackAxis.getFirst()).m_82524_(10.0f);
            Direction.Axis axis = Direction.m_122366_((double)biasedDirection.f_82479_, (double)biasedDirection.f_82480_, (double)biasedDirection.f_82481_).m_122434_();
            EdgePointType type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            TrackBufferBlockItem.withGraphLocation((Level)level, (BlockPos)pos, (boolean)front, null, (EdgePointType)type, (overlap, location) -> result.setValue(overlap));
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.m_5661_((Component)Lang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).m_130940_(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            if (!TrackBufferBlockItem.isOkShape(state)) {
                player.m_5661_((Component)Components.translatable((String)"railways.buffer.invalid_shape").m_130940_(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            CompoundTag stackTag = stack.m_41784_();
            stack.m_41751_(stackTag);
            CompoundTag oldTeTag = stackTag.m_128469_("BlockEntityTag");
            CompoundTag teTag = new CompoundTag();
            if (oldTeTag != null) {
                if (oldTeTag.m_128425_("Material", 10)) {
                    teTag.m_128365_("Material", oldTeTag.m_128423_("Material"));
                }
                if (oldTeTag.m_128425_("Color", 3)) {
                    teTag.m_128365_("Color", oldTeTag.m_128423_("Color"));
                }
            }
            teTag.m_128379_("TargetDirection", front);
            BlockPos placedPos = pos.m_7494_();
            Direction placeDirection = Direction.UP;
            TrackBufferBlock overrideBlock = null;
            if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_NARROW.get());
            } else if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_WIDE.get());
            } else if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_MONO.get());
                placedPos = context.m_43719_() == Direction.DOWN ? pos.m_7495_() : pos.m_7494_();
                placeDirection = context.m_43719_();
            }
            teTag.m_128365_("TargetTrack", (Tag)NbtUtils.m_129224_((BlockPos)pos.m_121996_((Vec3i)placedPos)));
            stackTag.m_128365_("BlockEntityTag", (Tag)teTag);
            TrackShape shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
            boolean diagonal = shape == TrackShape.PD || shape == TrackShape.ND;
            InteractionResult useOn = this.m_40576_(BufferBlockPlaceContext.at(new BlockPlaceContext(context), placedPos, placeDirection, Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)((Direction.AxisDirection)nearestTrackAxis.getSecond())), overrideBlock, diagonal));
            teTag.m_128473_("TargetTrack");
            teTag.m_128473_("TargetDirection");
            return useOn;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player != null) {
            player.m_5661_((Component)Lang.translateDirect((String)"track_target.invalid", (Object[])new Object[0]).m_130940_(ChatFormatting.RED), true);
            AllSoundEvents.DENY.play((Level)level, (Player)player, player.m_20182_(), 0.5f, 1.0f);
            return false;
        }
        return false;
    }
}

