/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.searchables.api.context;

import com.blamejared.searchables.api.context.SearchComponent;
import com.blamejared.searchables.api.context.SearchContext;
import com.blamejared.searchables.api.context.SearchLiteral;
import com.blamejared.searchables.lang.expression.Expression;
import com.blamejared.searchables.lang.expression.type.ComponentExpression;
import com.blamejared.searchables.lang.expression.type.GroupingExpression;
import com.blamejared.searchables.lang.expression.type.LiteralExpression;
import com.blamejared.searchables.lang.expression.type.PairedExpression;
import com.blamejared.searchables.lang.expression.visitor.Visitor;

public final class ContextVisitor<T>
implements Visitor<SearchContext<T>> {
    private final SearchContext<T> context = new SearchContext();

    @Override
    public SearchContext<T> visitGrouping(GroupingExpression expr) {
        expr.left().accept(this);
        expr.right().accept(this);
        return this.context;
    }

    @Override
    public SearchContext<T> visitComponent(ComponentExpression expr) {
        Expression expression = expr.left();
        if (expression instanceof LiteralExpression) {
            LiteralExpression leftLit = (LiteralExpression)expression;
            expression = expr.right();
            if (expression instanceof LiteralExpression) {
                LiteralExpression rightLit = (LiteralExpression)expression;
                this.context.add(new SearchComponent(leftLit.value(), rightLit.value()));
            }
        }
        return this.context;
    }

    @Override
    public SearchContext<T> visitLiteral(LiteralExpression expr) {
        this.context.add(new SearchLiteral(expr.value()));
        return this.context;
    }

    @Override
    public SearchContext<T> visitPaired(PairedExpression expr) {
        expr.first().accept(this);
        expr.second().accept(this);
        return this.context;
    }
}

