/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.lootr;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.data.DataStorage;
import snownee.jade.addon.lootr.LootrPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum LootrInfoProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        LootrInfoProvider.appendTooltip(tooltip, accessor);
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ILootBlockEntity) {
            ILootBlockEntity tile = (ILootBlockEntity)blockEntity;
            LootrInfoProvider.appendServerData(data, tile.getTileId());
        }
    }

    public static void appendTooltip(ITooltip tooltip, Accessor<?> accessor) {
        CompoundTag data = accessor.getServerData();
        int decayValue = data.m_128451_("LootrDecay");
        IThemeHelper t = IThemeHelper.get();
        if (decayValue > 0) {
            tooltip.add((Component)Component.m_237110_((String)"jadeaddons.lootr.decay", (Object[])new Object[]{t.seconds(decayValue)}));
        }
        if (data.m_128471_("LootrRefreshed")) {
            tooltip.add((Component)Component.m_237115_((String)"jadeaddons.lootr.refreshed"));
        } else {
            int refreshValue = data.m_128451_("LootrRefresh");
            if (refreshValue > 0) {
                tooltip.add((Component)Component.m_237110_((String)"jadeaddons.lootr.refresh", (Object[])new Object[]{t.seconds(refreshValue)}));
            }
        }
    }

    public static void appendServerData(CompoundTag data, UUID id) {
        int decayValue;
        if (!DataStorage.isDecayed((UUID)id) && (decayValue = DataStorage.getDecayValue((UUID)id)) > 0) {
            data.m_128405_("LootrDecay", decayValue);
        }
        if (DataStorage.isRefreshed((UUID)id)) {
            data.m_128379_("LootrRefreshed", true);
        } else {
            int refreshValue = DataStorage.getRefreshValue((UUID)id);
            if (refreshValue > 0) {
                data.m_128405_("LootrRefresh", refreshValue);
            }
        }
    }

    public ResourceLocation getUid() {
        return LootrPlugin.INFO;
    }
}

